﻿import mx.events.EventDispatcher;
import mx.utils.Delegate;

/**
 * This class is used to implement a secure login functionality into your applications. It uses MD5 hashes for authentication.
 */
class MD5Login
{
	//initialize the event dispatcher
	private static var EventDispatcherDependancy = EventDispatcher.initialize(MD5Login.prototype);
	
	//declare variables
	private var users_xml:XML;
	private var users:Array;
	private var loginmd:MD5;
	private var xmlpath:String;
	private var validuser:Object;
	
	//constructor
	public function MD5Login() 
	{
		users = new Array();
		
		users_xml = new XML();
		users_xml.ignoreWhite = true;
		
		loginmd = new MD5();
		
		users_xml.onLoad = Delegate.create(this, processXML);
	}
	
	//process XML file idf load is successful and tell that to listeners
	private function processXML(success) {
		if (success) {
			var tempstr:String = users_xml.toString();
			tempstr = replacestr(tempstr, "&gt;", ">");
			tempstr = replacestr(tempstr, "&lt;", "<");
			tempstr = replacestr(tempstr, "&quot;", "\"");
			if (tempstr.substr(0, 15) == "<encryptedtext>") {
				tempstr = tempstr.substr(15, tempstr.length-31);
				users_xml = new XML(EncryptDecrypt.decrypt(tempstr));
				users_xml.ignoreWhite = true;
			}
			for (var i:Number = 0; i < users_xml.firstChild.childNodes.length; i++) {
				var userObj:Object = new Object();
				userObj.username = users_xml.firstChild.childNodes[i].attributes.username;
				userObj.password = users_xml.firstChild.childNodes[i].attributes.password;
				userObj.details = users_xml.firstChild.childNodes[i].attributes.details;
				users.push(userObj);
			}
			dispatchEvent( { type:"UsersLoaded" } );
		}
	}
	
	//Use this function to load the 'users' xml file
	public function loadUsers(path:String) {
		if (xmlpath == path) {
			dispatchEvent( { type:"UsersLoaded" } );
		}else {
			xmlpath = path;
			users_xml.load(path);
		}
	}
	
	//Use this function to validate the user. This is to be called once the xml file is loaded
	public function validateUser(user:String, pass:String):Number {
		
		var founduser:String = "";
		var password:String = "";
		var result:Number = 0;
		
		for (var i:Number = 0; i < users.length; i++) 
		{
			if (users[i].username == user) {
				founduser = user;
				password = users[i].password;
				validuser = users[i];
			}
		}
		
		if (founduser == "") {
			result = 2;
			validuser = undefined;
		}else {
			if (loginmd.getMD5(pass) == password) {
				result = 1;
			}else {
				result = 0;
				validuser = undefined;
			}
		}
		
		return result;
	}
	
	private function replacestr(str:String, rep:String, rep1:String):String {
		return str.split(rep).join(rep1);
	}
	
	/**
	 * Use this property to get the validated user's username
	 */
	public function get validatedUser():Object {
		return validuser;
	}
	
	public function addEventListener() { };
	
	public function removeEventListener() { };
	
	private function dispatchEvent() { };
}