﻿import mx.utils.Delegate;
import mx.events.EventDispatcher;
import caurina.transitions.*;
import com.maheshj.utils.IXML;
import bgswitcher.BgImage;
import bgswitcher.SwitcherPanel;
import bgswitcher.Content;

/**
 * This class is the main application. The following events are dispatched by this class:<br/><br/>
 * <b><i>SwitcherInit</i></b> - dispatched when the all the listeners of the switcher are initialised<br/><br/>
 * <b><i>XMLInit</i></b> - dispatched after the XML is loaded, all elements aligned on stage and the slideshow is started<br/><br/>
 * <b><i>SlideShowToggled</i></b> - dispatched when the slideshow is either sitched on or off. This event has the following properties:<br/>
 * 		<i>state</i> - evaluates to either "true" or "false" (string) denoting if the slidshow was switched on or off.
 */
class bgswitcher.BGSwitcher extends MovieClip
{
	private static var EventDispatcherDependancy = EventDispatcher.initialize(BGSwitcher.prototype); 
	
	private var bg_mc:BgImage;
	private var liscount:Number;
	private var swp_mc:SwitcherPanel;
	private var pl_mc:MovieClip;
	private var inv_mc:MovieClip;
	private var info_mc:Content;
	
	private var slideshowon:String;
	private var slideshowint:Number;
	private var swalign:String;
	private var swalignmargin:Number;
	private var swtnum:Number;
	private var swthumbgap:Number;
	private var swthumbwidth:Number;
	private var swthumbheight:Number;
	private var swscroll:String;
	private var swdim:Number;
	private var imgarr:Array;
	private var main_xml:XML;
	private var showint:Number;
	private var currimg:Number;
	private var isinit:Boolean;
	private var prevnextdist:Number;
	private var infobtndist:Number;
	private var infovis:Boolean;
	
	public function BGSwitcher() 
	{
		Stage.align = "TL";
		Stage.scaleMode = "noScale";
		
		currimg = -1;
		
		isinit = false;
		
		infovis = false;
		
		inv_mc.enabled = false;
		
		Stage.addListener(this);
		
		imgarr = new Array();
		
		main_xml = IXML.createXML();
		
		main_xml.onLoad = Delegate.create(this, processXML);
		
		liscount = setInterval(this, "initSwitcher", 100);
	}
	
	/**
	 * This method looks if everything is loaded or not and then initializes all the listeners required by the application.
	 */
	private function initSwitcher() {
		if (_framesloaded == _totalframes) {
			
			onResize();
			
			bg_mc.addEventListener("BGVideoStopped", Delegate.create(this, function() {
				if (slideshowon == "true") {
					loadNext();
				}
				dispatchEvent( { type:"BGVideoStopped" } );
			}));
			
			bg_mc.addEventListener("BGVideoStarted", Delegate.create(this, function() {
				dispatchEvent( { type:"BGVideoStarted" } );
			}));
			
			bg_mc.addEventListener("ImageLoaded", Delegate.create(this, function() {
				pl_mc.pn_mc.prev_mc.enabled = true;
				pl_mc.pn_mc.next_mc.enabled = true;
				pl_mc.info_mc.enabled = true;
				inv_mc.enabled = true;
				if (slideshowon == "true") {
					startShow();
				}
				if (imgarr[currimg].title != undefined) {
					pl_mc.info_mc.enabled = true;
					Tweener.addTween(pl_mc.info_mc, { _alpha:100, time:0.4, transition:"easeInQuad" } );
				}else {
					pl_mc.info_mc.enabled = false;
					Tweener.addTween(pl_mc.info_mc, { _alpha:0, time:0.4, transition:"easeInQuad" } );
				}
				if (imgarr[currimg].title != undefined) {
					if (infovis) {
						info_mc.setVisibility(true);
					}
					info_mc.setText(imgarr[currimg].title, imgarr[currimg].desc);
				}else {
					info_mc.setVisibility(false);
				}
				Tweener.addTween(pl_mc.mask_mc, { _x: -pl_mc.mask_mc._width, time:0.7, delay:0.3, transition:"easeInOutQuad" } );
				dispatchEvent( { type:"ImageLoaded" } );
			}));
			
			bg_mc.addEventListener("ImageLoadInit", Delegate.create(this, function() {
				dispatchEvent( { type:"ImageLoadInit" } );
			}));
			
			bg_mc.addEventListener("ImageLoading", Delegate.create(this, function(e:Object) {
				Tweener.addTween(pl_mc.mask_mc, { _x:pl_mc.mask_mc._width * e.progress, time:0.2, transition:"easeOutQuad" } );
				pl_mc.pn_mc.prev_mc.enabled = false;
				pl_mc.pn_mc.next_mc.enabled = false;
				pl_mc.info_mc.enabled = false;
			}));
			
			swp_mc.addEventListener("ThumbClicked", this);
			
			swp_mc.addEventListener("SlideShowToggled", this);
			
			pl_mc.pn_mc.next_mc.onRelease = Delegate.create(this, function() {
				loadNext();
				if (swp_mc.slideShowOn == true) {
					swp_mc.toggleSlideShow();
				}
			});
			
			pl_mc.pn_mc.prev_mc.onRelease = Delegate.create(this, function() {
				loadPrevious();
				if (swp_mc.slideShowOn == true) {
					swp_mc.toggleSlideShow();
				}
			});
			
			pl_mc.info_mc.onRelease = Delegate.create(this, function() {
				if (infovis == true) {
					infovis = false;
				}else {
					infovis = true;
				}
				info_mc.toggleVisiblity();
			});
			
			isinit = true;
			
			dispatchEvent( { type:"SwitcherInit" } );
			
			clearInterval(liscount);
		};
	}
	
	/**
	 * method to process the XML data once it is loaded. It also does some of the initital alignment jobs
	 */
	private function processXML(success) {
		if (success) {
			
			for (var i:Number = 0; i < main_xml.firstChild.childNodes.length; i++) 
			{
				if (main_xml.firstChild.childNodes[i].nodeName == "options") 
				{
					for (var j:Number = 0; j < main_xml.firstChild.childNodes[i].childNodes.length; j++) 
					{
						if (main_xml.firstChild.childNodes[i].childNodes[j].nodeName == "slideshowon")
						{
							slideshowon = main_xml.firstChild.childNodes[i].childNodes[j].firstChild.nodeValue;
							if (slideshowon == "true") {
								bg_mc.loopVideo = false;
							}else {
								bg_mc.loopVideo = true;
							}
						}
						if (main_xml.firstChild.childNodes[i].childNodes[j].nodeName == "slideshowint")
						{
							slideshowint = parseInt(main_xml.firstChild.childNodes[i].childNodes[j].firstChild.nodeValue);
						}
						if (main_xml.firstChild.childNodes[i].childNodes[j].nodeName == "swalign")
						{
							swalign = main_xml.firstChild.childNodes[i].childNodes[j].firstChild.nodeValue;
						}
						if (main_xml.firstChild.childNodes[i].childNodes[j].nodeName == "swalignmargin")
						{
							swalignmargin = parseInt(main_xml.firstChild.childNodes[i].childNodes[j].firstChild.nodeValue);
						}
						if (main_xml.firstChild.childNodes[i].childNodes[j].nodeName == "swscroll")
						{
							swscroll = main_xml.firstChild.childNodes[i].childNodes[j].firstChild.nodeValue;
						}
						if (main_xml.firstChild.childNodes[i].childNodes[j].nodeName == "swdim")
						{
							swdim = parseInt(main_xml.firstChild.childNodes[i].childNodes[j].firstChild.nodeValue);
						}
						if (main_xml.firstChild.childNodes[i].childNodes[j].nodeName == "swtnum")
						{
							swtnum = parseInt(main_xml.firstChild.childNodes[i].childNodes[j].firstChild.nodeValue);
						}
						if (main_xml.firstChild.childNodes[i].childNodes[j].nodeName == "swthumbgap")
						{
							swthumbgap = parseInt(main_xml.firstChild.childNodes[i].childNodes[j].firstChild.nodeValue);
						}
						if (main_xml.firstChild.childNodes[i].childNodes[j].nodeName == "swthumbwidth")
						{
							swthumbwidth = parseInt(main_xml.firstChild.childNodes[i].childNodes[j].firstChild.nodeValue);
						}
						if (main_xml.firstChild.childNodes[i].childNodes[j].nodeName == "swthumbheight")
						{
							swthumbheight = parseInt(main_xml.firstChild.childNodes[i].childNodes[j].firstChild.nodeValue);
						}
						if (main_xml.firstChild.childNodes[i].childNodes[j].nodeName == "fadeeasetype")
						{
							bg_mc.fadeEaseType = main_xml.firstChild.childNodes[i].childNodes[j].firstChild.nodeValue;
						}
						if (main_xml.firstChild.childNodes[i].childNodes[j].nodeName == "fadetime")
						{
							bg_mc.fadeTime = parseFloat(main_xml.firstChild.childNodes[i].childNodes[j].firstChild.nodeValue);
						}
						if (main_xml.firstChild.childNodes[i].childNodes[j].nodeName == "prevnextdistance")
						{
							prevnextdist = parseInt(main_xml.firstChild.childNodes[i].childNodes[j].firstChild.nodeValue);
						}
						if (main_xml.firstChild.childNodes[i].childNodes[j].nodeName == "infobtndistance")
						{
							infobtndist = parseInt(main_xml.firstChild.childNodes[i].childNodes[j].firstChild.nodeValue);
						}
						var infowidth:Number;
						var infoheight:Number;
						if (main_xml.firstChild.childNodes[i].childNodes[j].nodeName == "infodialogwidth")
						{
							infowidth = parseInt(main_xml.firstChild.childNodes[i].childNodes[j].firstChild.nodeValue);
						}
						if (main_xml.firstChild.childNodes[i].childNodes[j].nodeName == "infodialogheight")
						{
							infoheight = parseInt(main_xml.firstChild.childNodes[i].childNodes[j].firstChild.nodeValue);
						}
						info_mc.resize(infowidth, infoheight);
						delete infowidth;
						delete infoheight;
					}
				}
				if (main_xml.firstChild.childNodes[i].nodeName == "images")
				{
					for (var j:Number = 0; j < main_xml.firstChild.childNodes[i].childNodes.length; j++)
					{
						var imgObj:Object = new Object();
						
						for (var k:Number = 0; k < main_xml.firstChild.childNodes[i].childNodes[j].childNodes.length; k++) 
						{
							if (main_xml.firstChild.childNodes[i].childNodes[j].childNodes[k].nodeName == "title") 
							{
								imgObj.title = main_xml.firstChild.childNodes[i].childNodes[j].childNodes[k].firstChild.nodeValue;
							}
							if (main_xml.firstChild.childNodes[i].childNodes[j].childNodes[k].nodeName == "desc") 
							{
								imgObj.desc = main_xml.firstChild.childNodes[i].childNodes[j].childNodes[k].firstChild.nodeValue;
							}
							if (main_xml.firstChild.childNodes[i].childNodes[j].childNodes[k].nodeName == "type") 
							{
								imgObj.imgtype = main_xml.firstChild.childNodes[i].childNodes[j].childNodes[k].firstChild.nodeValue;
							}
							if (main_xml.firstChild.childNodes[i].childNodes[j].childNodes[k].nodeName == "thumb") 
							{
								imgObj.thumb = main_xml.firstChild.childNodes[i].childNodes[j].childNodes[k].firstChild.nodeValue;
							}
							if (main_xml.firstChild.childNodes[i].childNodes[j].childNodes[k].nodeName == "img") 
							{
								imgObj.image = main_xml.firstChild.childNodes[i].childNodes[j].childNodes[k].firstChild.nodeValue;
							}
						}
						
						imgarr.push(imgObj);
					}
				}
			}
			arrangeSwitcher();
			switch(swalign) {
				case "right":
				pl_mc._rotation = -90;
				pl_mc._x = Stage.width + 5;
				pl_mc._y = pl_mc.mask_mc._width + 1 * swalignmargin;
				pl_mc.pn_mc._x = -prevnextdist;
				pl_mc.info_mc._x = -infobtndist;
				Tweener.addTween(pl_mc, { _x:(Stage.width - pl_mc._width), time:0.2, transition:"easeOutQuad", onComplete:Delegate.create(this, function() {
					arrangeSwitcher();
				}) } );
				break;
				
				case "left":
				pl_mc._rotation = 90;
				pl_mc._x = 0;
				pl_mc._y = swalignmargin;
				pl_mc.pn_mc._x = prevnextdist;
				pl_mc.info_mc._x = infobtndist;
				Tweener.addTween(pl_mc, { _x:pl_mc._width, time:0.2, transition:"easeOutQuad", onComplete:Delegate.create(this, function() {
					arrangeSwitcher();
				}) } );
				break;
				
				case "bottom":
				pl_mc._x = swalignmargin
				pl_mc._y = Stage.height + 5;
				pl_mc.pn_mc._x = prevnextdist;
				pl_mc.info_mc._x = infobtndist;
				Tweener.addTween(pl_mc, { _y:(Stage.height - pl_mc._height), time:0.2, transition:"easeOutQuad", onComplete:Delegate.create(this, function() {
					arrangeSwitcher();
				}) } );
				break;
				
				case "top":
				pl_mc._x = swalignmargin
				pl_mc._y = -pl_mc._height - 5;
				pl_mc.pn_mc._x = prevnextdist;
				pl_mc.info_mc._x = infobtndist;
				Tweener.addTween(pl_mc, { _y:0, time:0.2, transition:"easeOutQuad", onComplete:Delegate.create(this, function() {
					arrangeSwitcher();
				}) } );
				break;
			}
			
			swp_mc.init(imgarr, swscroll, swdim, swtnum, swthumbgap, swthumbwidth, swthumbheight, slideshowon);
			
			loadNext();
			
			dispatchEvent( { type:"XMLInit" } );
		}
	}
	
	/**
	 * Used for the slideshow
	 */
	public function startShow() {
		swp_mc.slideShowOn = true;
		if (!bg_mc.isVideo) {
			showint = setInterval(this, "loadNext", slideshowint * 1000);
		}
		slideshowon = "true";
	}
	
	/**
	 * This method is called each time a new image is to be loaded
	 */
	private function loadNext() {
		currimg++;
		if (currimg == imgarr.length) {
			currimg = 0;
		}
		if (imgarr[currimg].imgtype == "image") {
			bg_mc.loadImage(imgarr[currimg].image);
		}
		if (imgarr[currimg].imgtype == "video") {
			bg_mc.loadVideo(imgarr[currimg].image);
			if (imgarr[currimg].title != undefined) {
				pl_mc.info_mc.enabled = true;
				Tweener.addTween(pl_mc.info_mc, { _alpha:100, time:0.4, transition:"easeInQuad" } );
			}else {
				pl_mc.info_mc.enabled = false;
				Tweener.addTween(pl_mc.info_mc, { _alpha:0, time:0.4, transition:"easeInQuad" } );
			}
			if (imgarr[currimg].title != undefined) {
				if (infovis) {
					info_mc.setVisibility(true);
				}
				info_mc.setText(imgarr[currimg].title, imgarr[currimg].desc);
			}else {
				info_mc.setVisibility(false);
			}
		}
		clearInterval(showint);
	}
	
	private function loadPrevious() {
		currimg -= 1;
		if (currimg < 0) {
			currimg = 0;
		}else {
			if (imgarr[currimg].imgtype == "image") {
				bg_mc.loadImage(imgarr[currimg].image);
			}
			if (imgarr[currimg].imgtype == "video") {
				bg_mc.loadVideo(imgarr[currimg].image);
				if (imgarr[currimg].title != undefined) {
					if (infovis) {
						info_mc.setVisibility(true);
					}
					info_mc.setText(imgarr[currimg].title, imgarr[currimg].desc);
				}else {
					info_mc.setVisibility(false);
				}
			}
		}
		clearInterval(showint);
	}
	
	/**
	 * Used to stop the slideshow
	 */
	public function stopShow() {
		swp_mc.slideShowOn = false;
		clearInterval(showint);
		slideshowon = "false"
	}
	
	/**
	 * Used to arrange the elements of the application on resize
	 */
	private function arrangeSwitcher() {
		var myobj:Object = info_mc.getDimensions();
		with (info_mc) {
			_x = (Stage.width - myobj.width) / 2;
			_y = (Stage.height - myobj.height) / 2;
			delete myobj;
		}
		
		switch(swalign) {
			case "right":
			pl_mc._rotation = -90;
			pl_mc._x = Stage.width - pl_mc._width;
			pl_mc._y = pl_mc.mask_mc._width + 1 * swalignmargin;
			
			inv_mc._rotation = -90;
			inv_mc._x = Stage.width - inv_mc._width;
			inv_mc._y = inv_mc._height + 1*swalignmargin;
			
			swp_mc._x = Stage.width + 5;
			swp_mc._y = swalignmargin;
			
			inv_mc.onRollOver = Delegate.create(this, function() {
				inv_mc.enabled = false;
				swp_mc.scrolling = true;
				Tweener.addTween(pl_mc, { _x:(Stage.width + 5), time:0.2, transition:"easeOutQuad", onComplete:Delegate.create(this, function() {
					Tweener.addTween(swp_mc, { _x:(Stage.width - swp_mc.bg_mc._width), time:0.3, transition:"easeOutQuad" } );
					onEnterFrame = Delegate.create(this, function() {
						if ((_xmouse < Stage.width - swp_mc.bg_mc._width - 20) || (_ymouse < swp_mc._y) || (_ymouse > swp_mc.bg_mc._height + 1 * swp_mc._y)) {
							swp_mc.scrolling = false;
							Tweener.addTween(swp_mc, { _x:(Stage.width + 1*5), time:0.3, transition:"easeInQuad", onComplete:Delegate.create(this, function() {
								Tweener.addTween(pl_mc, { _x:(Stage.width - pl_mc._width), time:0.2, transition:"easeOutQuad"} );
							}) } );
							inv_mc.enabled = true;
							delete onEnterFrame;
						}
					});
				}) } );
			});
			break;
			case "left":
			pl_mc._rotation = 90;
			pl_mc._x = pl_mc._width;
			pl_mc._y = swalignmargin;
			
			inv_mc._rotation = 90;
			inv_mc._x = inv_mc._width;
			inv_mc._y = swalignmargin;
			
			swp_mc._x = -(1 * swtnum + 1) * (swthumbgap + 1 * swthumbwidth);
			swp_mc._y = swalignmargin;
			
			inv_mc.onRollOver = Delegate.create(this, function() {
				inv_mc.enabled = false;
				swp_mc.scrolling = true;
				Tweener.addTween(pl_mc, { _x:-5, time:0.2, transition:"easeOutQuad", onComplete:Delegate.create(this, function() {
					Tweener.addTween(swp_mc, { _x:0, time:0.3, transition:"easeOutQuad" } );
					onEnterFrame = Delegate.create(this, function() {
						if ((_xmouse > swp_mc.bg_mc._width + 1 * 20) || (_ymouse < swp_mc._y) || (_ymouse > swp_mc.bg_mc._height + 1 * swp_mc._y)) {
							swp_mc.scrolling = false;
							Tweener.addTween(swp_mc, { _x:-((1 * swtnum + 1) * (swthumbgap + 1 * swthumbwidth)), time:0.3, transition:"easeInQuad", onComplete:Delegate.create(this, function() {
								Tweener.addTween(pl_mc, { _x:pl_mc._width, time:0.2, transition:"easeOutQuad"} );
							}) } );
							inv_mc.enabled = true;
							delete onEnterFrame;
						}
					});
				}) } );
			});
			break;
			case "bottom":
			pl_mc._x = swalignmargin
			pl_mc._y = Stage.height - pl_mc._height;
			
			inv_mc._x = swalignmargin;
			inv_mc._y = Stage.height - inv_mc._height;
			
			swp_mc._x = swalignmargin;
			swp_mc._y = Stage.height + 5;
			
			inv_mc.onRollOver = Delegate.create(this, function() {
				inv_mc.enabled = false;
				swp_mc.scrolling = true;
				Tweener.addTween(pl_mc, { _y:Stage.height + 5, time:0.2, transition:"easeOutQuad", onComplete:Delegate.create(this, function() {
					Tweener.addTween(swp_mc, { _y:(Stage.height - swp_mc.bg_mc._height), time:0.3, transition:"easeOutQuad" } );
					onEnterFrame = Delegate.create(this, function() {
						if ((_xmouse < swp_mc._x) || (_xmouse > swp_mc._x + 1 * swp_mc.bg_mc._width) || (_ymouse < (Stage.height - swp_mc.bg_mc._height - 5))) {
							swp_mc.scrolling = false;
							Tweener.addTween(swp_mc, { _y:(Stage.height + 5), time:0.3, transition:"easeInQuad", onComplete:Delegate.create(this, function() {
								Tweener.addTween(pl_mc, { _y:(Stage.height - pl_mc._height), time:0.2, transition:"easeOutQuad"} );
							}) } );
							inv_mc.enabled = true;
							delete onEnterFrame;
						}
					});
				}) } );
			});
			break;
			case "top":
			pl_mc._x = swalignmargin
			pl_mc._y = 0;
			
			inv_mc._x = swalignmargin;
			inv_mc._y = 0;
			
			swp_mc._x = swalignmargin;
			if (swscroll == "vertical") {
				swp_mc._y = -swdim - 25 - 2*swthumbgap;
			}else {
				swp_mc._y = -(1 * swtnum + 1) * (swthumbgap + 1 * swthumbheight);
			}
			inv_mc.onRollOver = Delegate.create(this, function() {
				inv_mc.enabled = false;
				swp_mc.scrolling = true;
				Tweener.addTween(pl_mc, { _y:-(pl_mc._height + 5), time:0.2, transition:"easeOutQuad", onComplete:Delegate.create(this, function() {
					Tweener.addTween(swp_mc, { _y:0, time:0.3, transition:"easeOutQuad" } );
					onEnterFrame = Delegate.create(this, function() {
						if ((_xmouse < swp_mc._x) || (_xmouse > swp_mc._x + 1 * swp_mc.bg_mc._width) || (_ymouse > (swp_mc.bg_mc._height + 5))) {
							swp_mc.scrolling = false;
							Tweener.addTween(swp_mc, { _y:-(1*swp_mc.bg_mc._height + 5), time:0.3, transition:"easeInQuad", onComplete:Delegate.create(this, function() {
								Tweener.addTween(pl_mc, { _y:0, time:0.2, transition:"easeOutQuad"} );
							}) } );
							inv_mc.enabled = true;
							delete onEnterFrame;
						}
					});
				}) } );
			});
			break;
		}
	}
	
	/**
	 * Use this method to load the required XML file into the application.
	 * @param	path - the path to the XML file to be loaded
	 */
	private function loadXML(path:String) {
		if (isinit == true) {
			main_xml.load(path);
		}else {
			onEnterFrame = Delegate.create(this, function() {
				if (isinit == true) {
					main_xml.load(path);
					delete onEnterFrame;
				}
			});
		}
	}
	
	/**
	 * Use this property to load an XML file.
	 */
	public function set xmlFile(str:String) {
		if (str != undefined) {
			loadXML(str);
		}
	}
	
	/**
	 * Use this property to set whether the slideshow is on or not.
	 */
	public function get slideShowOn():Boolean {
		if (slideshowon == "true") {
			return true;
		}else {
			return false;
		}
	}
	
	public function set slideShowOn(bool:Boolean) {
		if (bool) {
			startShow();
			dispatchEvent( { type:"SlideShowSwitchedOn" } );
		}else {
			stopShow();
			dispatchEvent( { type:"SlideShowSwitchedOff" } );
		}
	}
	
	public function addEventListener() { };
	public function removeEventListener() { };
	private function dispatchEvent() { };
	
	/**
	 * Listener for stage
	 */
	private function onResize() {
		bg_mc.resize(Stage.width, Stage.height);
		arrangeSwitcher();
	}
	
	/**
	 * listener for ThumbClicked event
	 */
	private function ThumbClicked(e:Object) {
		if (imgarr[e.num].imgtype == "image") {
			bg_mc.loadImage(e.image);
		}
		if (imgarr[e.num].imgtype == "video") {
			bg_mc.loadVideo(e.image);
		}
		currimg = 1*e.num;
	}
	
	/**
	 * Listener for SlideShowToggled event
	 */
	private function SlideShowToggled(e:Object) {
		if (e.onoff == "true") {
			startShow();
			bg_mc.loopVideo = false;
		}else {
			stopShow();
			bg_mc.loopVideo = true;
		}
		dispatchEvent( { type:"SlideShowToggled", ison:e.onoff } );
	}
	
}