﻿import mx.events.EventDispatcher;
import com.maheshj.UI.MouseScrollBox;
import mx.utils.Delegate;
import bgswitcher.ThumbList;

/**
 * This class is the thumbnail list that you see in the application.The following events are dispatched by this class:<br/><br/>
 * <b><i>SlideShowToggled</i></b> - dispatched when the slideshow is switched on or off. The event object has the following properties:<br/>
 * 			<i>onoff</i> - A string that values to either "true" or "false" denoting the state of the slideshow.<br/><br/>
 * <b><i>ThumbClicked</i></b> - dispatched when a thumbnail in the thumblist is clicked The event object has the following properties:<br/>
 * 			<i>image</i> - A string that holds the image corresponding to the thumbnail clicked.<br/><br/>
 * 			<i>num</i> - A zero based integer that holds the number of the thumbnail that was clicked.<br/><br/>
 */

class bgswitcher.SwitcherPanel extends MovieClip
{
	private static var EventDispatcherDependancy = EventDispatcher.initialize(SwitcherPanel.prototype);
	
	private var scroll:String;
	private var dim:Number;
	private var tnum:Number;
	private var gap:Number;
	private var twidth:Number;
	private var theight:Number;
	private var sson:String;
	
	private var onoff_mc:MovieClip;
	public var bg_mc:MovieClip;
	private var header_mc:MovieClip;
	private var thumblist_mc:MouseScrollBox;
	
	public function SwitcherPanel() 
	{
		
	}
	
	/**
	 * Use this method to initialize the switcher panel.
	 * @param	imgarr - an array containing all the image objects that are extracted from the XML file. Each image object in the array contains information about the paths of thumbnail and corresponding image
	 * @param	scroll - the direction of the scroll - either <i>horizontal</i> or <i>vertical</i>
	 * @param	dim - the dimension of the switcher panel. This is the height of the panel if the scroll type is vertical and width if the scroll type is horizontal
	 * @param	tnum - the number of columns of thumbnails, if the scroll type is vertical and number of rows if the scroll type is horizontal
	 * @param	gap - the gap between the thumbnails
	 * @param	twidth - the width of each thumbnail. This is used by the application to align the thumbnails properly
	 * @param	theight - the height of each thumbnail. This is used by the application to align the thumbnails properly
	 * @param	sson - A string that evaluated itself to either "true" or "false" stating if the slideshow is on/off when the application starts
	 */
	public function init(imgarr:Array, scroll:String, dim:Number, tnum:Number, gap:Number, twidth:Number, theight:Number, sson:String) {
		
		this.scroll = scroll;
		this.dim = dim;
		this.tnum = tnum;
		this.gap = gap;
		this.twidth = twidth;
		this.theight = theight;
		this.sson = sson;
		
		ThumbList(thumblist_mc.content_mc).registerListener(this);
		
		if (scroll == "vertical") {
			thumblist_mc.scrollsVertically = true;
			thumblist_mc.scrollsHorizontally = false;
			bg_mc._width = (tnum) * twidth + (tnum) * gap;
			bg_mc._height = 4 * gap + header_mc._height + dim;
			thumblist_mc.resize((tnum - 1) * gap + tnum * twidth, dim);
		}else {
			thumblist_mc.scrollsVertically = false;
			thumblist_mc.scrollsHorizontally = true;
			bg_mc._width = 2 * gap + dim;
			bg_mc._height = (tnum) * theight + (tnum + 3) * gap + header_mc._height;
			thumblist_mc.resize(dim, (tnum) * gap + tnum * theight);
			thumblist_mc._x = gap;
		}
		
		var my_fmt:TextFormat = new TextFormat();
		my_fmt.letterSpacing = 1;
		
		onoff_mc.label_txt.setNewTextFormat(my_fmt);
		onoff_mc.label_txt.autoSize = true;
		
		if (sson == "true") {
			onoff_mc.label_txt.htmlText = "Слайдшоу - <font color='#00FF00'>Вкл</font>"
		}else {
			onoff_mc.label_txt.htmlText = "Слайдшоу - <font color='#FF0000'>Выкл</font>"
		}
		
		onoff_mc._x = bg_mc._width - onoff_mc._width - gap;
		header_mc._x = gap;
		
		header_mc._y = onoff_mc._y = gap;
		
		thumblist_mc._y = header_mc._y + header_mc._height + 2 * gap;
		
		ThumbList(thumblist_mc.content_mc).init(imgarr, twidth, theight, gap, tnum, scroll);
		
		onoff_mc.onRelease = Delegate.create(this, toggleSlideShow);
	}
	
	/**
	 * This method can be used to toggles slideshow on/off
	 */
	public function toggleSlideShow() {
		if (sson == "true") {
			onoff_mc.label_txt.htmlText = "Слайдшоу - <font color='#00FF00'>Вкл</font>"
			sson = "false";
		}else {
			onoff_mc.label_txt.htmlText = "Слайдшоу - <font color='#00FF00'>Выкл</font>"
			sson = "true";
		}
		dispatchEvent( { type:"SlideShowToggled", onoff:sson } );
	}
	
	private function ThumbClicked(e:Object) {
		dispatchEvent( { type:"ThumbClicked", image:e.loadObj.img, num:e.loadObj.num } );
		if (sson == "true") {
			toggleSlideShow();
		}
	}
	
	/**
	 * Use this property to set whether the switcher is scrolling or not.
	 */
	public function set scrolling(bool:Boolean) {
		if (bool == true) {
			thumblist_mc.startScrolling();
		}else {
			thumblist_mc.stopScrolling();
		}
	}
	
	/**
	 * Use this property to get or set wehther the slideshow is on or not.
	 */
	public function get slideShowOn():Boolean {
		var res:Boolean = false;
		if (sson == "true") {
			res = true;
		}else {
			res = false;
		}
		return res;
	}
	
	public function set slideShowOn(bool:Boolean) {
		if (bool) {
			onoff_mc.label_txt.htmlText = "Слайдшоу - <font color='#00FF00'>Вкл</font>"
			sson = "true";
		}else {
			onoff_mc.label_txt.htmlText = "Слайдшоу - <font color='#00FF00'>Выкл</font>"
			sson = "false";
		}
	}
	
	public function addEventListener() { };
	public function removeEventListener() { };
	private function dispatchEvent() { };
}