﻿import mx.utils.Delegate;
import mx.events.EventDispatcher;
import com.maheshj.utils.ImageLoader;
import caurina.transitions.*;
import bgswitcher.ThumbList;

/**
 * This class fomrs the basic thumbnail of the thumblist. The following events are dispatched by this class:<br/><br/>
 * <b><i>ThumbClicked</i></b> - dispatched when the a thumb is clicked. The <i>loadObj</i> property of the event object has all the datails required to load the right image when a thumbnails is clicked. The image is retrieved as <i>loadObj.img</i>, the thumbnail as <i>loadObj.thumb</i> and the number of the thumbnail as <i>loadObj.num</i>.<br/><br/>
 */
class bgswitcher.Thumb extends MovieClip
{
	private static var EventDispatcherDependancy = EventDispatcher.initialize(Thumb.prototype);
	
	private var twidth:Number;
	private var theight:Number;
	private var gap:Number;
	private var t1bg_mc:MovieClip;
	private var t1_mc:MovieClip;
	private var pl1_txt:TextField;
	private var t_il:ImageLoader;
	private var ct:MovieClip;
	private var mask_mc:MovieClip
	
	public var initObj:Object;
	
	public function Thumb() 
	{
		
		t1_mc._alpha = 0;
		
		t_il = new ImageLoader(this);
		
		t_il.addEventListener("loadInit", Delegate.create(this, function(e:Object) {
			pl1_txt.text = "";
			Tweener.addTween(t1_mc, { _alpha:100, time:0.2, transition:"easeInQuad" } );
			t1_mc._x = Math.round((twidth - ct._width) / 2);
			t1_mc._y = Math.round((theight - ct._height) / 2);
			t1_mc.width = t1_mc._width;
			t1_mc.height = t1_mc._height;
			t1_mc.x = t1_mc._x;
			t1_mc.y = t1_mc._y;
			dispatchEvent( { type:"ThumbLoaded", num:initObj.num} );
		}));
		
		t_il.onLoadProgress = Delegate.create(this, function(t_mc:MovieClip, bl:Number, bt:Number) {
			pl1_txt.text = Math.round((bl / bt) * 100);
		});
		
		if (ThumbList(_parent).scrollDirection == "vertical") {
			t1bg_mc._x = ThumbList(_parent).thumbGap;
			mask_mc._x = ThumbList(_parent).thumbGap;
		}
		t1_mc._x = t1bg_mc._x;
		t1bg_mc._width = ThumbList(_parent).thumbWidth;
		t1bg_mc._height = ThumbList(_parent).thumbHeight;
		pl1_txt._x = Math.round(t1_mc._x + (t1bg_mc._width - pl1_txt._width) / 2);
		pl1_txt._y = Math.round((t1bg_mc._height - pl1_txt._height) / 2);
		
		mask_mc._width = t1bg_mc._width
		mask_mc._height = t1bg_mc._height;
		
		t1_mc.onRollOver = Delegate.create(this, function() {
			Tweener.addTween(t1_mc, { _width:(t1_mc.width + 20), time:0.2, transition:"easeOutQuad" } );
			Tweener.addTween(t1_mc, { _height:(t1_mc.height + 20), time:0.2, transition:"easeOutQuad" } );
			Tweener.addTween(t1_mc, { _x:(t1_mc.x - 10), time:0.2, transition:"easeOutQuad" } );
			Tweener.addTween(t1_mc, { _y:(t1_mc.y - 10), time:0.2, transition:"easeOutQuad" } );
		});
		
		t1_mc.onRollOut = t1_mc.onReleaseOutside = Delegate.create(this, function() {
			Tweener.addTween(t1_mc, { _width:t1_mc.width, time:0.2, transition:"easeOutQuad" } );
			Tweener.addTween(t1_mc, { _height:t1_mc.height, time:0.2, transition:"easeOutQuad" } );
			Tweener.addTween(t1_mc, { _x:t1_mc.x, time:0.2, transition:"easeOutQuad" } );
			Tweener.addTween(t1_mc, { _y:t1_mc.y, time:0.2, transition:"easeOutQuad" } );
		});
		
		t1_mc.onRelease = Delegate.create(this, function() {
			dispatchEvent( { type:"ThumbClicked", loadObj:initObj } );
		});
		
		if (initObj.num == 0) {
			loadThumb();
		}
	}
	
	/**
	 * Use this property to get the path of the image that should be loaded when the thumbnail is clicked.
	 */
	public function get imgPath():String {
		return initObj.img;
	}
	
	/**
	 * Use this function to load the thumbnail image into the thumbnail. This function was used to implement a sequential loading for the thumbnails.
	 */
	public function loadThumb() {
		t_il.loadimg(initObj.thumb, t1_mc);
	}
	
	public function addEventListener() { };
	
	public function removeEventListener() { };
	
	private function dispatchEvent() { };
	
}