﻿import mx.events.EventDispatcher;
import mx.utils.Delegate;
import com.maheshj.utils.IXML;

/**
 * This is the thumb list class for the application. It actually forms the <i>content_mc</i> movieclip of <i>MouseScrollBox</i> class used in this file. The scrollbox helps to scroll through the thumbnails items.<br/><br/>
 * The following events are dispatched by this class:<br/><br/>
 * <b><i>ThumbClicked</i></b> - dispatched when the a thumb is clicked. The <i>loadObj</i> property of the event object has all the datails required to load the right image when a thumbnails is clicked. The image is retrieved as <i>loadObj.img</i>, the thumbnail as <i>loadObj.thumb</i> and the number of the thumbnail as <i>loadObj.num</i>.<br/><br/>
 * <b><i>ThumbListInit</i></b> - dispatched afer the initialization of the list<br/><br/>
 */
class bgswitcher.ThumbList extends MovieClip
{
	private static var EventDispatcherDependancy = EventDispatcher.initialize(ThumbList.prototype);
	
	private var thumbarr:Array;
	private var _twidth:Number;
	private var _theight:Number;
	private var _gap:Number;
	private var _col:Number;
	private var imgarr:Array;
	private var _dir:String;
	
	public function ThumbList() 
	{
		thumbarr = new Array();
	}
	
	/**
	 * Function called to initialize the list
	 * @param	arr - array containing the paths to thumbnail images
	 * @param	width - width of the thumbnail
	 * @param	height - height of the thumbnail
	 * @param	gap - gap between the thumbnails
	 * @param	col - the number of columns
	 * @param	dir - the direction of scrolling
	 */
	public function init(arr:Array, width:Number, height:Number, gap:Number, col:Number, dir:String ) {
		imgarr = arr;
		_dir = dir;
		createThumbs(width, height, gap, col, dir);
	}
	
	private function createThumbs(width:Number, height:Number, gap:Number, col:Number, dir:String) {
		_twidth = width
		_theight = height
		_gap = gap
		_col = col
			
		for (var i:Number = 0; i < imgarr.length; i++) 
		{
			removeMovieClip(this["thumb" + i + "_mc"]);
		}
			
		var newx:Number = 0;
			
		var newy:Number = 0;
			
		for (var i:Number = 0; i < imgarr.length; i++) 
		{
			var initobj:Object = new Object();
			
			initobj.thumb = imgarr[i].thumb;
			initobj.img = imgarr[i].image;
			initobj.num = i;
				
			attachMovie("thumb", "thumb" + i + "_mc", i + 10, {_alpha:0, initObj:initobj } );	
		}
			
		var xc:Number = 0;
		
		if (dir == "vertical") {
			for (i = 0; i < imgarr.length; i++) {
				this["thumb" + i + "_mc"].addEventListener("ThumbClicked", this);
				this["thumb" + i + "_mc"].addEventListener("ThumbLoaded", this);
				this["thumb" + i + "_mc"]._y = newy;
				this["thumb" + i + "_mc"]._x = newx;
				this["thumb" + i + "_mc"]._alpha = 100;
				xc++;
				if (xc == _col) {
					xc = 0;
					newy += 1 * _theight + 1 * _gap;
				}
				newx = xc * (1 * _twidth + 1 * _gap);
			}
		}else {
			for (i = 0; i < imgarr.length; i++) {
				this["thumb" + i + "_mc"].addEventListener("ThumbClicked", this);
				this["thumb" + i + "_mc"].addEventListener("ThumbLoaded", this);
				this["thumb" + i + "_mc"]._y = newy;
				this["thumb" + i + "_mc"]._x = newx;
				this["thumb" + i + "_mc"]._alpha = 100;
				xc++;
				if (xc == _col) {
					xc = 0;
					newx += 1 * _twidth + 1 * _gap;
				}
				newy = xc * (1 * _theight + 1 * _gap);
			}
		}
			
		dispatchEvent( { type:"ThumbListInit" } );
	}
	
	/**
	 * Use this method to register any movieclip as a listener to this class' events
	 * @param	mc - the movieclip that is to be registered
	 */
	public function registerListener(mc:MovieClip) {
		this.addEventListener("ThumbListInit", mc);
		this.addEventListener("ThumbClicked", mc);
	}
	
	/**
	 * Use this function to get the path of the image to be loaded for a particular thumbnail
	 * @param	i - the number of the thumbnail
	 * @return - the path of the image
	 */
	public function imgPath(i:Number):String {
		return this["thumb" + i + "_mc"].imgPath;
	}
	
	private function ThumbClicked(e:Object) {
		dispatchEvent( { type:"ThumbClicked", loadObj:e.loadObj } );
	}
	
	private function ThumbLoaded(e:Object) {
		this["thumb" + (1*e.num + 1) + "_mc"].loadThumb();
	}
	
	public function addEventListener() { };
	public function removeEventListener() { };
	private function dispatchEvent() { };
	
	/**
	 * Use this property to get the width of the thumbnail. It is set when the gallery xml file is parsed. This property is used by <i>Thumb</i> class to align and scale the thumbnails properly.
	 */
	public function get thumbWidth():Number {
		return _twidth;
	}
	
	/**
	 * Use this property to get the gap between thumbnails alignments. It is set when the gallery xml file is parsed. This property is used by <i>Thumb</i> class to align and scale the thumbnails properly.
	 */
	public function get thumbGap():Number {
		return _gap;
	}
	
	/**
	 * Use this property to get the height of the thumbnail. It is set when the gallery xml file is parsed. This property is used by <i>Thumb</i> class to align and scale the thumbnails properly
	 */
	public function get thumbHeight():Number {
		return _theight;
	}
	
	/**
	 * Use this method to get the number of columns of thumbnails the list has
	 */
	public function get colNum():Number {
		return _col;
	}
	
	/**
	 * Use this method to get the total number of thumbnails
	 */
	public function get totalThumbs():Number {
		return imgarr.length;
	}
	
	public function get scrollDirection():String {
		return _dir;
	}
}