﻿import com.maheshj.UI.ScrollBar;
import com.maheshj.utils.ContentLoader;
import mx.events.EventDispatcher;
import mx.utils.Delegate;
import caurina.transitions.*;
import com.pixelbreaker.ui.MouseWheel;

/**
 * This is a scroller class into which you can load jpg, png, gif or swf's. You can scroll the content both horizontally and vertically. The class will take care of all the resizing for you and all you have to do is initialize it with the desired scrolling dimensions. You may change them later as well. The following events are dispatched by this class:<br/><br/>
 * 		<b><i>ScrollPaneResized</i></b> - This event is fired when the scroller is resized from the outside (maybe due to a stage resize listener). The event object has the following properties:<br/>
 * 			<i>width</i> - A number denoting the width of the displayed content.<br/>
 * 			<i>height</i> - A number denoting the height of the displayed content.<br/>
 * 		You can listen to this event to know when the scrollbox is resized. The scrollbox has a movieclip with name content_mc into which all the dynamic content will be loaded. This movieclip is registered with the event by default when the scrollbox is initialized.<br/><br/>
 * 		<b><i>ConLoadStarted</i></b> - Same as <i>onLoadStart</i> event of <i>MovieClipLoader</i> class. Fired when content starts loading after <i>loadContent</i> function is called.<br/><br/>
 * 		<b><i>ConLoading</i></b> - Same as <i>onLoadProgress</i> event of <i>MovieClipLoader</i> class. Fired when content progresses loading after <i>loadContent</i> function is called. The event object has an object names <i>loadProgress</i> which has two properties <i>bytesLoaded</i> and <i>bytesTotal</i> which can be used to track the progress of the loading.<br/><br/>
 * 		<b><i>ConLoadInit</i></b> - Same as <i>onLoadInit</i> event of <i>MovieClipLoader</i> class. Fired when content initializes loading after <i>loadContent</i> function is called.<br/><br/>
 * 		<b><i>ConLoadComplete</i></b> - Same as <i>onLoadComplete</i> event of <i>MovieClipLoader</i> class. Fired when content completes loading after <i>loadContent</i> function is called.<br/><br/>
 * 		<b><i>ConLoadError</i></b> - Same as <i>onLoadError</i> event of <i>MovieClipLoader</i> class. Fired when error occurs while loading content after <i>loadContent</i> function is called.<br/><br/>
 * 
 * <b>Usage:</b>
 * 		Since this class extends MovieClip class, you must attach it to a movieclip that you want to behave as a scrollbox. For this class to function properly, you need to have <i>mask_mc</i> movieclip that will mask the content to be scrolled and a movieclip named <i>content_mc</i>. The content will be loaded into this movieclip. All these movieclips must be placed inside the movieclip to which you will attach this class.
 * 
 * To attach this class to a movieclip, in the library, right-click on the movieclip that you want to use as scrollbox, and select <i>Linkage</i>. In the <i>Class:</i> field, write <i>com.maheshj.UI.MouseScrollBox</i> and click <i>OK</i>. Make sure that the <i>com</i> directory in which the scroller classes are provided are available in the FLA's classpaths.<br/>
 * 
 * Once you get the scroller ready on stage, you should use the <i>startScrolling</i> method to start the scrolling of the content. Since the scroller uses onEnterFrame which is resource intensive, this will help in optimise the performance.
 */
class com.maheshj.UI.MouseScrollBox extends MovieClip {
	
	private static var EventDispatcherDependancy = EventDispatcher.initialize(MouseScrollBox.prototype);
	
	private var mask_mc:MovieClip;
	public var content_mc:MovieClip;
	private var con_cl:ContentLoader;
	
	private var h_scroll:Boolean;
	private var v_scroll:Boolean;
	
	private var scrollWidth:Number;
	private var scrollHeight:Number;
	private var orig_scrollWidth:Number;
	private var orig_scrollHeight:Number;
	
	private var scroll_time:Number;
	private var scroll_delay:Number;
	private var scroll_ease:String;
	
	private function MouseScrollBox() {
		onEnterFrame = Delegate.create(this, function() {
			if (scrollsHorizontally == undefined) {
				init(mask_mc._width, mask_mc._height, true, true);
			}
		});
	}
	
	/**
	 * This method is used to initialize the scrollbox with the desired properties as listed below. All these parameters are except <i>hScrollHeight</i> and <i>vScrollHeight</i> are optional. If others parameters are not specified in the function call, they are initialized to <i>false</i>
	 * @param	hScrollHeight - Number representing the height of the horizontal scrollbar as well as its scrollheight
	 * @param	vScrollHeight - Number representing the height of the vertical scrollbar as well as its scrollheight
	 * @param	hScroll - <i>[Optional]</i> A boolean value to specify whether horizontal scrolling is enabled or not.
	 * @param	vScroll - <i>[Optional]</i> A boolean value to specify whether vertical scrolling is enabled or not.
	 */
	public function init(hScrollHeight:Number, vScrollHeight:Number, hScroll:Boolean, vScroll:Boolean) {
		
		this.addEventListener("ScrollPaneResized", content_mc);
		
		con_cl = new ContentLoader();
		
		con_cl.onLoadStart = Delegate.create(this, function() {
			resize();
			dispatchEvent( { type:"ConLoadStarted" } );
		});
		con_cl.onLoadInit = Delegate.create(this, function() {
			resize();
			this.addEventListener("ScrollPaneResized", content_mc);
			dispatchEvent( { type:"ConLoadInit" } );
		});
		con_cl.onLoadComplete = Delegate.create(this, function() {
			dispatchEvent( { type:"ConLoadComplete" } );
		});
		con_cl.onLoadProgress = Delegate.create(this, function(t_mc:MovieClip, bl:Number, bt:Number) {
			dispatchEvent( { type:"ConLoading", loadProgress:con_cl.getProgress(t_mc) } );
		});
		con_cl.onLoadError = Delegate.create(this, function(t_mc:MovieClip, errorCode:String, httpStatus:Number) {
			dispatchEvent( { type:"ConLoadError", errorCode:errorCode, httpStatus:httpStatus } );
		});
		
		scrollsHorizontally = hScroll;
		scrollsVertically = vScroll;
		
		scrollDelay = 0;
		scrollTime = 0.3;
		scrollEaseType = "easeOutQuad"
		
		resize(hScrollHeight, vScrollHeight);
		
	}
	
	/**
	 * If the ScrollBox is used to load content dynamically into it at runtime, then the content can be loaded with this method.
	 * @param	path - The path of the file to be loaded into <i>content_mc</i> movieclip.
	 */
	public function loadContent(path:String) {
		con_cl.loadContent(path, content_mc);
	}
	
	/**
	 * If you want to resize the scrollbox at runtime after setting up the scroll width and height initially, you can use this method.
	 * @param	width - <i>[Optional]</i> The width to which it is to be resized.
	 * @param	height - <i>[Optional]</i> The height to which it is to be resized.
	 */
	public function resize(width:Number, height:Number) {
		
		if ((width != undefined) and (width > 0)) {
			scrollWidth = width;
			mask_mc._width = scrollWidth;
		}
		
		if ((height != undefined) and (height > 0)) {
			scrollHeight = height;
			mask_mc._height = scrollHeight;
		}
		
		scroll();
		
		dispatchEvent( { type:"ScrollPaneResized" , width:mask_mc._width, height:mask_mc._height} );
	}
	
	private function scroll() {
		if ((_xmouse >= mask_mc._x) and (_xmouse <= mask_mc._x + mask_mc._width) and (_ymouse >= mask_mc._y) and (_ymouse <= mask_mc._y + mask_mc._height)) {
			if (scrollsHorizontally and (content_mc._width > scrollWidth)) {
				//if (!Tweener.isTweening(content_mc)) {
					Tweener.addTween(content_mc, { _x: -((_xmouse / mask_mc._width) * (content_mc._width - mask_mc._width)), time:scrollTime, transition:scrollEaseType, delay:scrollDelay } );
				//}
			}
			if (scrollsVertically and (content_mc._height > scrollHeight)) {
				//if (!Tweener.isTweening(content_mc)) {
					Tweener.addTween(content_mc, { _y: -((_ymouse / mask_mc._height) * (content_mc._height - mask_mc._height)), time:scrollTime, transition:scrollEaseType, delay:scrollDelay } );
				//}
			}
		}
	}
	
	/**
	 * Use this method to start scrolling. Note that scrolling doesn't start unless you call this method.
	 */
	public function startScrolling() {
		onEnterFrame = Delegate.create(this, scroll);
	}
	
	/**
	 * Use this method to stop the scrolling.
	 */
	public function stopScrolling() {
		delete onEnterFrame;
	}
	
	/**
	 * Use this property to get or set whether the scrollbox will scroll horizontally or not. The valid values are <i>true</i> or <i>false</i>
	 */
	public function get scrollsHorizontally():Boolean {
		return h_scroll;
	}
	
	public function set scrollsHorizontally(bool:Boolean) {
		h_scroll = bool;
	}
	
	/**
	 * Use this property to get or set whether the scrollbox will scroll vertically or not. The valid values are <i>true</i> or <i>false</i>
	 */
	public function get scrollsVertically():Boolean {
		return v_scroll;
	}
	public function set scrollsVertically(bool:Boolean) {
		v_scroll = bool;
	}
	
	/**
	 * Use this property to get and set the delay in scrolling. Default value is 0.
	 */
	public function get scrollDelay() {
		return scroll_delay;
	}
	
	public function set scrollDelay(num:Number) {
		if (num != undefined) {
			scroll_delay = Math.abs(num);
		}
	}
	
	/**
	 * Use this property to get and set the time for the scrolling to happen. Default value is 0.5.
	 */
	public function get scrollTime() {
		return scroll_time;
	}
	
	public function set scrollTime(num:Number) {
		if (num != undefined) {
			scroll_time = Math.abs(num);
		}
	}
	
	/**
	 * Use this property to get and set the easing type for the scrolling animation. Default value is <i>easeOutQuad</i>. But you can use all the easeing types offered by Tweener.
	 */
	public function get scrollEaseType() {
		return scroll_ease;
	}
	
	public function set scrollEaseType(type:String) {
		scroll_ease = type;
	}
	
	public function addEventListener() {}
	
	public function removeEventListener() {}
	
	private function dispatchEvent() {}
}