﻿import com.maheshj.UI.core.Dimensions;
import com.maheshj.utils.IXML;
import mx.utils.Delegate;
import mx.events.EventDispatcher;

/**
 * A generic class that extends the functionality of a movieclip to implement custom width, height, resize, scale, visible functionalities. This class can be used to implement any functionality that involves sequencing a transition based on the four states of the display object (init, enter, exit, destroy). This also has a built in XML processing functionality. All you have to do is override and implement the <i>processXML</i> method, set the XML file using the <i>xmlFile</> property and finally call the loadXML method.
 */
class com.maheshj.UI.core.DisplayObject extends MovieClip
{
	private static var EventDispatcherDependancy = EventDispatcher.initialize(DisplayObject.prototype); 
	
	public var addEventListener:Function; 
	
	public var removeEventListener:Function; 
	
	public var dispatchEvent:Function; 
	
	private var xpath:String;
	
	private var obj_xml:XML;
	
	private var _vis:Boolean;
	
	public function DisplayObject() {
		_vis = true;
	}
	
	public function init() { 
		dispatchEvent( { type:"DisplayObjectInit" } );
	}
	
	public function enter() {
		dispatchEvent( { type:"DisplayObjectEnter" } );
	}
	
	public function exit() { 
		dispatchEvent( { type:"DisplayObjectExit" } );
	}
	
	public function destroy() { 
		dispatchEvent( { type:"DisplayObjectDestroyec" } );
	}
	
	private function initXML() {
		
		obj_xml = IXML.createXML();
		
		obj_xml.onLoad = Delegate.create(this, processXML);
		
	}
	
	public function getDimensions():Dimensions {
		var dim:Dimensions = new Dimensions(_width, _height);
		return dim;
	}
	
	public function resize(w:Number, h:Number) {
		_width = w;
		_height = h;
	}
	
	public function enable() { 
		enabled = true;
	}
	
	public function disable() {
		enabled = false;
	}
	
	private function processXML(success:Boolean) {
		trace("Default handler for XML data load for " + this);
	}
	
	public function loadXML() {
		if (obj_xml == undefined and xpath != undefined) {
			initXML();
		}
		obj_xml.load(xpath);
	}
	
	public function set xmlFile(path:String) {
		xpath = path;
		if (obj_xml == undefined and path != undefined) {
			initXML();
		}
	}
	
	public function set scale(perc:Number) {
		_xscale = _yscale = perc
	}
	
	public function get visible():Boolean {
		return _vis;
	}
	
	public function set visible(bool:Boolean) {
		_vis = bool;
		_visible = false;
	}
}