﻿import com.maheshj.UI.core.DisplayObject;
import com.maheshj.UI.core.GenericMenuManager;
import mx.events.EventDispatcher;
import template.MenuItemInitData;

/**
 * A generic class used to implement the core functionality of a single level menu. Extend this class to implement your own menus.
 */
class com.maheshj.UI.core.GenericMenu extends DisplayObject
{
	
	private var gap:Number;
	private var manager:GenericMenuManager;
	private var _isactive:Boolean;
	private var menuarr:Array;
	private var _hasdefault:Boolean;
	
	/**
	 * The constructor. Used to instantiate a GenericMenuManager object. Override this method if you have extended the GenericMenuManager and want to use that for your menu.
	 */
	public function GenericMenu() 
	{
		manager = new GenericMenuManager(this);
		_isactive = true;
	}
	
	/**
	 * Method used to initialize all the variables, functionality, etc.
	 */
	public function init() {
		if (xpath != undefined) {
			loadXML();
		}
	}
	
	/**
	 * Call this function to make the menu appear.
	 */
	public function enter() {
		createMenu();
	}
	
	private function processXML(success:Boolean) {
		if (success) {
			menuarr = manager.processXML(obj_xml);
			enter();
		}
	}
	
	private function createMenu() { };
	
	/**
	 * Use thie method to get an object containing the info for a given menu item based on the passed ID.
	 * @param	str - the ID of the menu item
	 * @return - the object containing different menu item variables
	 */
	public function getLinkByID(str:String):Object {
		var menuObj:Object;
		for (var i:Number = 0; i < menuarr.length; i++) 
		{
			this["item" + i + "_mc"].enter();
		}
		for (i = 0; i < menuarr.length; i++) 
		{
			if (this["item" + i + "_mc"].ID == str) {
				menuObj = this["item" + i + "_mc"].itemObj;
				break;
			}
		}
		return menuObj;
	}
	
	private function MenuItemClicked(e:MenuItemInitData) {
		isActive = false;
		dispatchEvent( { type:"MenuItemClicked", itemObj:e.itemObj } );
		for (var i:Number = 0; i < menuarr.length; i++) 
		{
			if(this["item" + i + "_mc"] != e.target)
			this["item" + i + "_mc"].reset();
		}
	}
	
	/**
	 * Use this method to register any movieclip as a listener to the events of this class.
	 * @param	mc - the movieclip that is to be registered
	 */
	public function registerListener(mc:DisplayObject) {
		this.addEventListener("MainMenuInit", mc);
		this.addEventListener("MenuItemClicked", mc);
	}
	
	/**
	 * Use this method to tigger the default menu item.
	 */
	public function getDefaultItem() {
		for (var i:Number = 0; i < menuarr.length; i++) 
		{
			if (menuarr[i].isdefault == "true") {
				this["item" + i + "_mc"].triggerRelease();
				return;
			}
		}
	}
	
	public function get itemGap():Number {
		return gap;
	}
	
	public function set itemGap(num:Number) {
		gap = num;
	}
	
	public function get isActive():Boolean {
		return _isactive;
	}
	
	public function set isActive(bool:Boolean) {
		_isactive = bool;
	}
	
	public function get hasDefault():Boolean {
		return _hasdefault;
	}
	
}