﻿import mx.events.EventDispatcher; 

/**
 * This is a class that can be used a substitute to load images and swf's into any movieclip. The reason one may choose this as a substitute to <i>MovieClipLoader</i> class is that you don't have to create a separate listener object to listen to the load events. All the events dispatched by this class are the same as that if <i>MovieClipLoader</i> class.<br/><br/>
 * 
 * <b>Usage:</b><br/>
 * 		An example usage can be something like this:<br/><br/>
 * 			import com.maheshj.utils.ContentLoader;<br/>
 * 			var con_cl:ContentLoader = new ContentLoader();<br/>
 * 			this.createEmptyMovieClip("content_mc", this.getNextHighestDepth());<br/>
 * 			con_cl.onLoadInit = function(){<br/>
 * 				trace("content loaded");<br/>
 * 			}<br/>
 * 
 * 			con_cl.loadContent("1.jpg", content_mc);<br/><br/>
 * 		Here <i>1.jpg</i> can be any image you want to load into the <i>content_mc</i> movieclip.<br/>
 */
class com.maheshj.utils.ContentLoader extends MovieClipLoader {

	private static var EventDispatcherDependancy = EventDispatcher.initialize(ContentLoader.prototype);
	
	private var loadProgress:Object;
	
	private var img_mc:MovieClip;

	public function ContentLoader() {
		
		loadProgress = new Object();
	}
	
	/**
	 * Use this method to load content into any movieclip.
	 * @param	path - The path of the file which is to be loaded
	 * @param	img_mc - The movieclip into which the file is to be loaded
	 */
	public function loadContent(path:String, img_mc:MovieClip){
		
		this.img_mc = img_mc;
		
		//this.loadClip(path+ "?rand=" + Math.random(1000), img_mc);
		
		this.loadClip(path, img_mc);
	}
	
	public function onLoadStart(){}
	
	public function onLoadProgress(t_mc:MovieClip, bl:Number, bt:Number){}
	
	public function onLoadInit(t_mc:MovieClip){}
	
	public function onLoadComplete() {};
	
	public function onLoadError(t_mc:MovieClip, errorCode:String, httpStatus:Number){}
	
	public function addEventListener() {}
	
	public function removeEventListener() {}
	
	private function dispatchEvent() {}
		
	
}