﻿import com.maheshj.utils.mp3.PlayList;
import com.maheshj.utils.mp3.PlaylistItem;
import mx.utils.Delegate;
import mx.events.EventDispatcher;

/**
 * ...
 * This class forms the basic functional framework of any MP3 player that you can model. It helps in keeping UI separate from the functionality.
 */
class com.maheshj.utils.mp3.Mp3PlayBackManager 
{
	private static var EventDispatcherDependancy = EventDispatcher.initialize(Mp3PlayBackManager.prototype); 
	public var addEventListener:Function; 
	public var removeEventListener:Function; 
	public var dispatchEvent:Function; 
	
	private var player_mc:MovieClip;
	private var playlist_arr:PlayList;
	private var mymusic:Sound;
	private var currentTrackNum:Number;
	private var currPos:Number;
	private var isPlaying:Boolean;
	
	/**
	 * Constructor of the class. Does not take any parameters
	 */
	public function Mp3PlayBackManager()
	{
		mymusic = new Sound();
		
		mymusic.onSoundComplete = Delegate.create(this, playNext);
		
		currentPlayingTrackNum = 0;
	}
	
	/**
	 * Function to be called when you have to resume music playback. Dispatches an event with name "MusicStarted".
	 */
	public function playMusic():Void {
		if (mymusic.duration != undefined) {
			mymusic.start(currPos);
			isPlaying = true;
			dispatchEvent({type:"MusicStarted"});
		}else {
			playTrackNum(currentPlayingTrackNum);
		}
	}
	
	/**
	 * Function to be called when you have to pause music playback. Dispatches an event with name "MusicPaused".
	 */
	public function pauseMusic():Void {
		mymusic.stop();
		currPos = mymusic.position / 1000;
		isPlaying = false;
		
		dispatchEvent({type:"MusicPaused"});
	}
	
	/**
	 * Function to be called when you have to stop music playback. Dispatches an event with name "MusicStopped".
	 */
	public function stopMusic():Void {
		mymusic.stop();
		currPos = 0;
		isPlaying = false;
		
		dispatchEvent({type:"MusicStopped"});
	}
	
	/**
	 * Function to be called when you have to go to next track. Dispatches an event with name "NextTrackSelected".
	 */
	public function playNext() {
		if (currentTrackNum < playlist_arr.length - 1) {
			currentTrackNum++;
		}else {
			currentTrackNum = 0;
		}
		mymusic.loadSound(PlaylistItem(playlist_arr.getItem(currentPlayingTrackNum)).file, true);
		
		dispatchEvent({type:"NextTrackSelected"});
	}
	
	/**
	 * Function to be called when you have to go to previous track. Dispatches an event with name "PreviousTrackSelected".
	 */
	public function playPrev() {
		if (currentTrackNum > 0) {
			currentTrackNum--;
		}else {
			currentTrackNum = playlist_arr.length - 1;
		}
		mymusic.loadSound(PlaylistItem(playlist_arr.getItem(currentPlayingTrackNum)).file, true);
		
		dispatchEvent({type:"PreviousTrackSelected"});
	}
	
	/**
	 * If music is being played then it will be paused and vice versa.
	 */
	public function togglePlayBack() {
		if (isPlaying) 
		{
			pauseMusic();
		}else {
			if (mymusic.duration == undefined) {
				playTrackNum(currentPlayingTrackNum);
			}else {
				playMusic();
			}
		}
	}
	
	/**
	 * This function can be called when you wnt to play a specific track in the playlist. Dispatches an event with name "TrackChanged".
	 * @param	num the track number to be played. It is a zero indexed value.
	 */
	public function playTrackNum(num:Number) {
		currPos = 0;
		isPlaying = true;
		if (num != undefined) {
			currentTrackNum = num;
		}else {
			currentTrackNum = 0;
		}
		
		mymusic.loadSound(PlaylistItem(playlist_arr.getItem(currentPlayingTrackNum)).file, true);
		
		dispatchEvent({type:"TrackChanged", selectedTrack:currentPlayingTrack});
	}
	
	/**
	 * This function can be called to change the volume of the music being played.
	 * @param	num the value for the volume ranging between 0 and 100.
	 */
	private function setVolume(num:Number) {
		mymusic.setVolume(num);
		dispatchEvent( { type:"VolumeChanged" } );
	}
	
	/**
	 * This is basically an array. The array elements are a set of objects containting various track properties. The most basic properties are "file" - path of the mp3 file  and "title" - the title of the file to be displayed on the player when being played. You can add many other properties to the object which you may want to use with the player you are making.
	 */
	public function get playlist():PlayList {
		return playlist_arr;
	}
	
	public function set playlist(list:PlayList) {
		playlist_arr = list;
	}
	
	/**
	 * You can get and set the current playing track number with the property.
	 */
	public function get currentPlayingTrackNum():Number {
		return currentTrackNum;
	}
	
	public function set currentPlayingTrackNum(num:Number) {
		if (num < playlist_arr.length) {
			currentTrackNum = num;
		}else {
			currentTrackNum = 0;
		}
	}
	
	/**
	 * You can get the current playing track's title with this property.
	 */
	public function get currentPlayingTrack():String {
		return playlist_arr[currentTrackNum].title;
	}
	
	/**
	 * You can get the current playing track's path with this property.
	 */
	public function get currentPlayingTrackPath():String {
		return playlist_arr[currentTrackNum].file;
	}
	
	/**
	 * You can get and set the playback volume with this property.
	 */
	public function get volume():Number {
		return mymusic.getVolume();
	}
	
	public function set volume(num:Number) {
		if ((num <= 100) and (num >= 0)) {
			setVolume(num);
		}
	}
}