﻿import com.maheshj.utils.ContentLoader;
import com.maheshj.utils.ImageLoader;
import mx.utils.Delegate;
import mx.events.EventDispatcher;
import caurina.transitions.*;
import com.pixelbreaker.ui.MouseWheel;

/**
 * This class is the backgound of the gallery into which the images load and all the cool masking transitions happen. The following events are dispatched by this class:<br/><br/>
 * <b><i>ImageLoaded</i></b> - dispatched when the image is loaded<br/><br/>
 */
class imagegal.BgImage extends MovieClip
{
	private static var EventDispatcherDependancy = EventDispatcher.initialize(BgImage.prototype); 
	
	private var img_il:ImageLoader;
	private var swf_cl:ContentLoader;
	private var b_mc:MovieClip;
	private var a_mc:MovieClip;
	private var pl_mc:MovieClip;
	private var imgwidth:Number;
	private var imgheight:Number;
	private var c_mc:MovieClip;
	private var currtype:String;
	private var scaling:String;
	private var tempscalemode:String;
	private var zoomlevel:Number;
	private var mouselist:Object;
	private var zoom:Boolean;
	private var mscroll:Boolean;
	
	public function BgImage() 
	{	
		img_il = new ImageLoader(this);
		
		img_il.onLoadStart = Delegate.create(this, function() {
			pl_mc.gotoAndPlay("in");
		});
		
		img_il.onLoadProgress = Delegate.create(this, function(t_mc:MovieClip, bl:Number, bt:Number) {
			pl_mc.pl_txt.text = "LOADING..." + Math.round((bl / bt) * 100) + "%";
		});
		
		img_il.addEventListener("loadInit", Delegate.create(this, function(e:Object) {
			pl_mc.pl_txt.text = "";
			pl_mc.gotoAndPlay("out");
			c_mc._visible = false;
			resize();
			var w:Number = c_mc.mask_mc._width;
			c_mc.mask_mc._width = 0;
			c_mc._visible = true;
			if (c_mc == a_mc) {
				Tweener.addTween(b_mc.mask_mc, { _width:0, time:(Stage.width / 1000) * 0.4, transition:"easeInOutQuart" } );
			}else {
				Tweener.addTween(a_mc.mask_mc, { _width:0, time:(Stage.width / 1000) * 0.4, transition:"easeInOutQuart" } );
			}
			Tweener.addTween(c_mc.mask_mc, { _width:w, time:(Stage.width/1000)*0.4, delay:(Stage.width/1000) * 0.5, transition:"easeInOutQuart", onComplete:Delegate.create(this, function() {
				resize();
				if (c_mc == a_mc) {
					b_mc._visible = false;
				}else {
					a_mc._visible = false;
				}
				if (zoomEnabled)
				{
					MouseWheel.addListener(mouselist);
				}
				if (mouseScrollEnabled)
				{
					onMouseMove = Delegate.create(this, mouseScroll);
				}else {
					delete onMouseMove;
				}
				dispatchEvent( { type:"ImageLoaded" } );
			} ) } );
		}));
		
		swf_cl = new ContentLoader();
		
		swf_cl.onLoadStart = Delegate.create(this, function() {
			pl_mc.gotoAndPlay("in");
		});
		
		swf_cl.onLoadProgress = Delegate.create(this, function(t_mc:MovieClip, bl:Number, bt:Number) {
			pl_mc.pl_txt.text = "LOADING..." + Math.round((bl / bt) * 100) + "%";
		});
		
		swf_cl.onLoadInit = Delegate.create(this, function() {
			pl_mc.pl_txt.text = "";
			pl_mc.gotoAndPlay("out");
			c_mc._visible = false;
			resize();
			var w:Number = c_mc.mask_mc._width;
			c_mc.mask_mc._width = 0;
			c_mc._visible = true;
			if (c_mc == a_mc) {
				Tweener.addTween(b_mc.mask_mc, { _width:0, time:(Stage.width/1000)*0.4, transition:"easeInOutQuart" } );
			}else {
				Tweener.addTween(a_mc.mask_mc, { _width:0, time:(Stage.width/1000)*0.4, transition:"easeInOutQuart" } );
			}
			Tweener.addTween(c_mc.mask_mc, { _width:w, time:(Stage.width/1000)*0.4, delay:(Stage.width/1000)*0.5, transition:"easeInOutQuart", onComplete:Delegate.create(this, function() {
				resize();
				dispatchEvent( { type:"ImageLoaded" } );
				if (c_mc == a_mc) {
					b_mc._visible = false;
				}else {
					a_mc._visible = false;
				}
			} ) } );
		});
		
		scaling = "fill";
		
		c_mc = a_mc;
		
		mouselist = new Object();
		mouselist.onMouseWheel = Delegate.create(this, function(delta)
		{
			if (zoomEnabled)
			{
				tempscalemode = "none";
				zoomlevel += delta;
				if (zoomlevel < 10)
				{
					zoomlevel = 10;
				}
				if (zoomlevel > 150)
				{
					zoomlevel = 150;
				}
				resizeImg(c_mc);
			}
		});
		
		a_mc.useHandCursor = false;
		a_mc.onRelease = Delegate.create(this, function()
		{
			tempscalemode = scaleMode;
			resize();
		});
		
		b_mc.useHandCursor = false;
		b_mc.onRelease = Delegate.create(this, function()
		{
			tempscalemode = scaleMode;
			resize();
		});
		
		zoom = false;
		mscroll = false;
	}
	
	public function loadImage(path:String) {
		currtype = "image";
		Tweener.removeTweens(a_mc.holder_mc);
		Tweener.removeTweens(b_mc.holder_mc);
		b_mc.swapDepths(a_mc);
		if (c_mc == b_mc) {
			c_mc = a_mc;
		}else {
			c_mc = b_mc;
		}
		tempscalemode = scaleMode;
		MouseWheel.removeListener(mouselist);
		img_il.loadimg(path, c_mc.holder_mc);
	}
	
	public function loadSWF(path:String) {
		currtype = "swf";
		b_mc.swapDepths(a_mc);
		if (c_mc == b_mc) {
			c_mc = a_mc;
		}else {
			c_mc = b_mc;
		}
		swf_cl.loadContent(path, c_mc.holder_mc);
	}
	
	/**
	 * Use this function to resize the background to certain dimensions
	 * @param	w - value for the width
	 * @param	h - value for the height
	 */
	public function resize(w:Number, h:Number) {
		if ((w != undefined) and (h != undefined)) {
			imgwidth = w;
			imgheight = h;
			with (a_mc.mask_mc) {
				_width = w;
				_height = h;
			}
			with (b_mc.mask_mc) {
				_width = w;
				_height = h;
			}
			pl_mc._x = w / 2;
			pl_mc._y = h / 2;
		}
		if (c_mc.holder_mc._width != 0) {
			resizeImg(c_mc);
		}
	}
	
	private function resizeImg(mc:MovieClip) {
		var w:Number = mc.mask_mc._width;
		var h:Number = mc.mask_mc._height;
		var tw:Number;
		var th:Number;
		var scale:Number = 100;
		/*with (mc.holder_mc) {
			_xscale = 100;
			_yscale = 100;
		}*/
		//var scaleMode:String = tempscalemode;
		tw = mc.holder_mc._width/(mc.holder_mc._xscale/100);
		th = mc.holder_mc._height/(mc.holder_mc._yscale/100);
		if (currtype == "image") {
			if (tempscalemode == "fill")
			{
				/*if ((mc.holder_mc._width > mc.holder_mc._height) and (mc.holder_mc._width > w)) {
					scale = (w / mc.holder_mc._width) * 100;
				}
				if ((mc.holder_mc._height > mc.holder_mc._width) and (mc.holder_mc._height > h)) {
					scale = (h / mc.holder_mc._height) * 100;
				}*/
				if ((tw > w) or (th > h)) {
					if (w/tw > h/th) {
						scale = (w / tw) * 100;
					}else {
						scale = (h / th) * 100;
					}
				}
			}
			if (tempscalemode == "fit")
			{
				if ((tw > w) or (th > h)) {
					if (w/tw > h/th) {
						scale = (h / th) * 100;
					}else {
						scale = (w / tw) * 100;
					}
				}
			}
			if (tempscalemode == "none")
			{
				scale = zoomlevel;
			}
			zoomlevel = scale;
			tw = tw * scale / 100;
			th = th * scale / 100;
			Tweener.addTween(mc.holder_mc, { _xscale:scale, time:0.5, transition:"easeOutQuad" } );
			Tweener.addTween(mc.holder_mc, { _yscale:scale, time:0.5, transition:"easeOutQuad" } );
			/*mc.holder_mc._xscale = scale;
			mc.holder_mc._yscale = scale;*/
		}
		if (!mouseScrollEnabled)
		{
			Tweener.addTween(mc.holder_mc, { _x:(w - tw) / 2, time:0.5, transition:"easeOutQuad" } );
			Tweener.addTween(mc.holder_mc, { _y:(h - th) / 2, time:0.5, transition:"easeOutQuad" } );
		}else {
			if (tw < imgwidth)
			{
				Tweener.addTween(mc.holder_mc, { _x:(w - tw) / 2, time:0.5, transition:"easeOutQuad" } );
			}
			if (th < imgheight)
			{
				Tweener.addTween(mc.holder_mc, { _y:(h - th) / 2, time:0.5, transition:"easeOutQuad" } );
			}
			mouseScroll(tw, th);
		}
		/*mc.holder_mc._x = (w - mc.holder_mc._width) / 2;
		mc.holder_mc._y = (h - mc.holder_mc._height) / 2;*/
	}
	
	private function mouseScroll(w:Number, h:Number) {
		if (w != undefined)
		{
			if (w >= imgwidth)
			{
				Tweener.addTween(c_mc.holder_mc, { _x: -((_xmouse / imgwidth) * (w - imgwidth)), time:0.5, transition:"easeOutQuad"} );
			}
			if (h >= imgheight)
			{
				Tweener.addTween(c_mc.holder_mc, { _y: -((_ymouse / imgheight) * (h - imgheight)), time:0.5, transition:"easeOutQuad"} );
			}
		}else {
			if (c_mc.holder_mc._width >= imgwidth)
			{
				Tweener.addTween(c_mc.holder_mc, { _x: -((_xmouse / imgwidth) * (c_mc.holder_mc._width - imgwidth)), time:0.5, transition:"easeOutQuad"} );
			}
			if (c_mc.holder_mc._height >= imgheight)
			{
				Tweener.addTween(c_mc.holder_mc, { _y: -((_ymouse / imgheight) * (c_mc.holder_mc._height - imgheight)), time:0.5, transition:"easeOutQuad"} );
			}
		}
	}
	
	public function get scaleMode():String
	{
		return scaling;
	}
	
	public function set scaleMode(str:String)
	{
		scaling = str;
	}
	
	public function get zoomEnabled():Boolean
	{
		return zoom;
	}
	
	public function set zoomEnabled(bool:Boolean)
	{
		if (zoom != bool)
		{
			if (bool)
			{
				MouseWheel.addListener(mouselist);
			}else {
				MouseWheel.removeListener(mouselist);
			}
			zoom = bool;
		}
	}
	
	public function get mouseScrollEnabled():Boolean
	{
		return mscroll;
	}
	
	public function set mouseScrollEnabled(bool:Boolean)
	{
		if (mscroll != bool)
		{
			if (!bool)
			{
				delete onMouseMove;
			}else {
				onMouseMove = Delegate.create(this, mouseScroll);
			}
			mscroll = bool;
		}
	}
	
	public function addEventListener() { };
	public function removeEventListener() { };
	private function dispatchEvent() { };
}