﻿import mx.events.EventDispatcher;

/**
 * This is the main menu class for the gallery. It actually forms the <i>content_mc</i> movieclip of <i>MouseScrollBox</i> class used in this file. The scrollbox helps to scroll through the menu items based on mouse position.<br/><br/>
 * The following events are dispatched by this class:<br/><br/>
 * <b><i>MenuItemClicked</i></b> - dispatched when the a menu item is clicked. It's event object has a property <i>xmlpath</i> that holds thae path to the gallery xml file corresponding to the menu item clicked<br/><br/>
 * <b><i>MainMenuInit</i></b> - dispatched afer the initializatio the menu items<br/><br/>
 */
class imagegal.MainMenu extends MovieClip
{
	private static var EventDispatcherDependancy = EventDispatcher.initialize(MainMenu.prototype);
	
	private var gap:Number;
	private var rownum:Number;
	private var menuarr:Array;
	private var _isactive:Boolean;
	
	public function MainMenu()
	{
		menuarr = new Array();
		_isactive = false;	
	}
	
	/**
	 * Use this method to initialize the menu.
	 * @param	arr - the array of objects containing menuitems' details
	 * @param	rows - number of rows for the menu
	 * @param	gapval - the gap between each menu item
	 */
	public function init(arr:Array, rows:Number, gapval:Number) {
		gap = gapval;
		rownum = rows;
		menuarr = arr;
		/*if (menuarr.length != 1) {
			_isactive = true;
		}else {
			_isactive = false;
		}*/
		//_isactive = true;
		createMenu();
	}
	
	private function createMenu() {
		var newx:Number = 0;
		var newy:Number = 0;
		var my_mc:MovieClip;
		
		for (var i:Number = 0; i < menuarr.length; i++) 
		{
			my_mc = attachMovie("mainmenuitem", "item" + i + "_mc", i + 10, {_alpha:0, enabled:false } );
		}
		
		for (i = 0; i < menuarr.length; i++) 
		{
			if ((i % rownum == 0) and (i > 0)) {
				newy = 0;
				newx += this["item" + i + "_mc"]._width + 1*gap;
			}
			this["item" + i + "_mc"].addEventListener("MenuItemClicked", this);
			this["item" + i + "_mc"].init(menuarr[i].title, menuarr[i].xmlfile, menuarr[i].ID);
			this["item" + i + "_mc"]._x = newx;
			this["item" + i + "_mc"]._y = newy;
			this["item" + i + "_mc"]._alpha = 100;
			
			newy += this["item" + i + "_mc"]._height + 1*gap;
		}
		
		dispatchEvent( { type:"MainMenuInit" } );
	}
	
	/**
	 * Use this function to enable all the items of the menu.
	 */
	public function enable() {
		for (var i:Number = 0; i < menuarr.length; i++) 
		{
			this["item" + i + "_mc"].enabled = true;
		}
	}
	
	private function MenuItemClicked(e:Object) {
		isActive = false;
		dispatchEvent( { type:"MenuItemClicked", xmlpath:e.target.xmlPath, ID:e.target.ID } );
	}
	
	/**
	 * Use this method to register any movieclip as a listener to the events of this class.
	 * @param	mc - the movieclip that is to be registered
	 */
	public function registerListener(mc:MovieClip) {
		this.addEventListener("MainMenuInit", mc);
		this.addEventListener("MenuItemClicked", mc);
	}
	
	public function addEventListener() { };
	public function removeEventListener() { };
	private function dispatchEvent() { };
	
	/**
	 * Use this property to get or set whether the menu is active or not. This property is used by <i>PhotoRetoucherGallery</i> class to manage the alignments of the list on the stage.
	 */
	public function get isActive():Boolean {
		return _isactive;
	}
	
	public function set isActive(bool:Boolean) {
		_isactive = bool;
	}
	
	public function getXMLPath(id:String):String {
		for (var i:Number = 0; i < menuarr.length; i++) 
		{
			if (this["item" + i + "_mc"].ID == id) {
				return this["item" + i + "_mc"].xmlPath;
				break;
			}
		}
		return "null";
	}
	
	public function loadDefault() {
		_isactive = false;
		dispatchEvent( { type:"MenuItemClicked", xmlpath:this["item0_mc"].xmlPath, ID:this["item0_mc"].ID } );
	}
	
}