﻿import mx.events.EventDispatcher;
import mx.utils.Delegate;
import caurina.transitions.*;

/**
 * This is the main menu item class for the gallery. The following events are dispatched by this class:<br/><br/>
 * <b><i>MenuItemClicked</i></b> - dispatched when the a menu item is clicked.<br/><br/>
 */
class imagegal.MainMenuItem extends MovieClip
{
	private static var EventDispatcherDependancy = EventDispatcher.initialize(MainMenuItem.prototype);
	
	private var label_txt:TextField;
	private var xmlfile:String;
	private var id:String;
	
	public function MainMenuItem() 
	{
		onRollOver = Delegate.create(this, function() {
			//label_txt.textColor = 0xffa133;
		});
		onRollOut = onReleaseOutside = Delegate.create(this, function() {
			//label_txt.textColor = 0x000000;
		});
		onRelease = Delegate.create(this, function() {
			dispatchEvent( { type:"MenuItemClicked" } );
		});
	}
	
	/**
	 * Used to initialise the menu item with the title and the xml file it should load.
	 * @param	title - the title that shows up on the menu item
	 * @param	file - the path to xml file that is to be loaded when the menuitem is clicked
	 */
	public function init(title:String, file:String, ID:String) {
		label_txt.text = title;
		xmlfile = file;
		id = ID;
	}
	
	public function addEventListener() { };
	public function removeEventListener() { };
	private function dispatchEvent() { };
	
	/**
	 * Use this property to get the path of the xml file that is to be loaded when the menu item is clicked.
	 */
	public function get xmlPath():String {
		return xmlfile;
	}
	
	public function get ID():String {
		return id;
	}
	
	/**
	 * Use this method to register any movieclip as a listener to the events of this class.
	 * @param	mc - the movieclip that is to be registered
	 */
	public function registerListener(mc:MovieClip) {
		this.addEventListener("MenuItemClicked", mc);
	}
	
}