﻿import com.maheshj.utils.IXML;
import mx.utils.Delegate;

/**
 * This is the class that is attached to the movieclip that displays the description of an image.
 */
dynamic class imagegal.TextContentLoader extends MovieClip
{
	private var content_txt:TextField;
	private var ol_mc:MovieClip;
	
	private var style:TextField.StyleSheet;
	
	public function TextContentLoader() 
	{
		init();
	}
	
	public function init() {
		content_txt.autoSize = true;
		content_txt.html = true;
		content_txt.condenseWhite = true;
		
		style = new TextField.StyleSheet();
		style.load("textstyle.css");
		content_txt.styleSheet = style;
	}
	
	/**
	 * Use this function to set the text to be displayed
	 * @param	str - the text tp be displayed
	 */
	public function setText(str:String) {
		if (str != undefined) {
			content_txt.htmlText = str;
			_parent.resize();
		}
	}
	
	private function setContentWidth(num:Number) {
		content_txt._width = num - 5;
	}
	
	private function ScrollPaneResized(e:Object) {
		setContentWidth(e.width, e.height);
	}
	
}