﻿import mx.utils.Delegate;
import mx.events.EventDispatcher;
import com.maheshj.utils.ImageLoader;
import caurina.transitions.*;
import imagegal.ThumbList;

/**
 * This class fomrs the basic thumbnail of the thumblist. It has the holders for 'before' image thumb, 'after' image thumb, the grey arrow, the green arrow, rollover overlay, etc.he following events are dispatched by this class:<br/><br/>
 * <b><i>ThumbClicked</i></b> - dispatched when the a thumb is clicked. The <i>loadObj</i> property of the event object has all the datails required to load the right image when a thumbnails is clicked. The 'before' image is retrieved as <i>loadObj.bimg</i> and the 'after' as <i>loadObj.aimg</i>.<br/><br/>
 */
class imagegal.Thumb extends MovieClip
{
	private static var EventDispatcherDependancy = EventDispatcher.initialize(Thumb.prototype);
	
	private var twidth:Number;
	private var theight:Number;
	private var gap:Number;
	private var t1bg_mc:MovieClip;
	private var t1_mc:MovieClip;
	private var rollover_mc:MovieClip;
	private var pl1_txt:TextField;
	private var t_il:ImageLoader;
	private var ct:MovieClip;
	private var mask_mc:MovieClip;
	private var label_txt:TextField;
	private var labelbg_mc:MovieClip;
	
	public var initObj:Object;
	
	public function Thumb() 
	{
		rollover_mc._alpha = 0;
		
		t1_mc._alpha = 0;
		
		t_il = new ImageLoader(this);
		
		t_il.addEventListener("loadInit", Delegate.create(this, function(e:Object) {
			pl1_txt.text = "";
			Tweener.addTween(t1_mc, { _alpha:100, time:0.2, transition:"easeInQuad" } );
			t1_mc._x = Math.round((twidth - ct._width) / 2);
			t1_mc._y = Math.round((theight - ct._height) / 2);
			dispatchEvent( { type:"ThumbLoaded", num:initObj.num} );
		}));
		
		t_il.onLoadProgress = Delegate.create(this, function(t_mc:MovieClip, bl:Number, bt:Number) {
			pl1_txt.text = Math.round((bl / bt) * 100) + "%";
		});
		
		t1bg_mc._x = ThumbList(_parent).thumbGap;
		t1_mc._x = t1bg_mc._x;
		t1bg_mc._width = ThumbList(_parent).thumbWidth;
		t1bg_mc._height = ThumbList(_parent).thumbHeight;
		pl1_txt._x = Math.round(t1_mc._x + (t1bg_mc._width - pl1_txt._width) / 2);
		pl1_txt._y = Math.round((t1bg_mc._height - pl1_txt._height) / 2);
		
		rollover_mc._x = ThumbList(_parent).thumbGap;
		rollover_mc._width = t1bg_mc._width
		rollover_mc._height = t1bg_mc._height;
		
		mask_mc._x = ThumbList(_parent).thumbGap;
		mask_mc._width = t1bg_mc._width
		mask_mc._height = t1bg_mc._height;
		
		label_txt._width = t1bg_mc._width - 4;
		label_txt._x = ThumbList(_parent).thumbGap + 2;
		label_txt.autoSize = true;
		label_txt._alpha = 0;
		
		if (initObj.title != undefined) {
			label_txt.text = initObj.title;
		}else {
			label_txt.text = "No title provided";
		}
		
		labelbg_mc._x = -t1bg_mc._width - 1*5;
		labelbg_mc._width = t1bg_mc._width;
		labelbg_mc._height = label_txt._height + 4;
		labelbg_mc._y = (t1bg_mc._height - labelbg_mc._height) / 2;
		label_txt._y = labelbg_mc._y + 1*1;
		
		rollover_mc.onRollOver = Delegate.create(this, function() {
			Tweener.removeTweens(rollover_mc);
			Tweener.removeTweens(label_txt);
			Tweener.removeTweens(labelbg_mc);
			Tweener.addTween(rollover_mc, { _alpha:100, time:0.2, transition:"easeInQuad", onComplete:Delegate.create(this, function() {
				Tweener.addTween(labelbg_mc, { _x:ThumbList(_parent).thumbGap, time:0.3, transition:"easeInOutQuart", onComplete:Delegate.create(this, function() {
					Tweener.addTween(label_txt, { _alpha:100, time:0.3, transition:"easeInOutQuart" } );
				}) });
			}) } );
		});
		
		rollover_mc.onRollOut = Delegate.create(this, function() {
			Tweener.removeTweens(rollover_mc);
			Tweener.removeTweens(label_txt);
			Tweener.removeTweens(labelbg_mc);
			Tweener.addTween(rollover_mc, { _alpha:0, time:0.2, transition:"easeInQuad", onComplete:Delegate.create(this, function() {
				Tweener.addTween(label_txt, { _alpha:0 , time:0.3, transition:"easeInOutQuart", onComplete:Delegate.create(this, function() {
					Tweener.addTween(labelbg_mc, { _x:-(labelbg_mc._width + 5), time:0.3, transition:"easeInOutQuart" } );
				}) });
			}) } );
		});
		
		rollover_mc.onRelease = Delegate.create(this, function() {
			dispatchEvent( { type:"ThumbClicked", loadObj:initObj } );
		});
		
		if (initObj.num == 0) {
			loadThumb();
		}
	}
	
	/**
	 * Use this property to get the path of the image that should be loaded when the thumbnail is clicked.
	 */
	public function get imgPath():String {
		return initObj.img;
	}
	
	public function get imgTitle():String {
		return initObj.title;
	}
	
	public function get imgInfo():String {
		return initObj.info;
	}
	
	public function get ID():String {
		return initObj.ID;
	}
	
	public function get Type():String {
		return initObj.type;
	}
	
	/**
	 * Use this function to load the thumbnail into the thumbnail. This function was used in the gallery to implement a sequential loading for the thumbnails.
	 */
	public function loadThumb() {
		t_il.loadimg(initObj.thumb, t1_mc);
	}
	
	public function addEventListener() { };
	
	public function removeEventListener() { };
	
	private function dispatchEvent() { };
	
}