﻿import template.TemplateDisplayObject;
import com.maheshj.UI.VerticalScrollBox;
import mx.data.types.Obj;
import mx.utils.Delegate;
import mx.events.EventDispatcher;
import com.maheshj.utils.IXML;
import com.maheshj.UI.MouseScrollBox;
import caurina.transitions.*;
import imagegal.*;

/**
 * This is the main class of the gallery that holds all the mechanism to execute its every need in perfect synchronisation. In the library, this class is atached to <i>prgallery</i> movieclip.
 */
class imagegal.XMLImageGallery extends TemplateDisplayObject{
	
	private var menu_mc:MouseScrollBox;
	private var thumblist_mc:VerticalScrollBox;
	private var bg_mc:BgImage;
	private var gal_xml:XML;
	private var scaletostage:String;
	private var galheight:Number;
	private var galwidth:Number;
	private var menuarr:Array;
	private var st_list:Object;
	private var init_list:Object;
	private var themask_mc:MovieClip;
	private var back_mc:MovieClip;
	private var bmenu_mc:BottomMenu;
	private var isexam:Boolean;
	private var liscount:Number;
	private var ol_mc:MovieClip;
	private var currimg:Number;
	private var info_mc:Content;
	private var infoheight:Number;
	private var infovisible:Boolean;
	private var infovistemp:Boolean;
	private var rkeylist:Object;
	private var lkeylist:Object;
	private var infokeylist:Object;
	private var thumbskeylist:Object;
	private var menukeylist:Object;
	private var zoomenabled:Boolean;
	private var mousescroll:Boolean;
	
	private var catxmlpath:String;
	private var catID:String;
	private var tempcatid:String;
	
	private var gen_txt:TextField;
	
	public function XMLImageGallery() 
	{
		super();
		
		info_mc._y = System.capabilities.screenResolutionY;
		
		info_mc._alpha = 100;
		
		menu_mc._alpha = 0;
		
		menu._mc._visible = false;
		
		thumblist_mc._alpha = 0;
		
		thumblist_mc._visible = false;
		
		infovisible = false;
		
		infovistemp = false;
		
		init_list = new Object();
		
		isexam = false;
		
		gal_xml = IXML.createXML();
		gal_xml.onLoad = Delegate.create(this, processXML);
		
		st_list = new Object();
		st_list.onResize = Delegate.create(this, StageResized);
		
		Stage.addListener(st_list);

		back_mc.onRelease = Delegate.create(this, function() {
			menu_mc.content_mc.isActive = true;
			thumblist_mc.content_mc.isActive = false;
			StageResized();
			showMenu();
		});
		
		ol_mc.useHandCursor = false;
		ol_mc.onRollOver = function() { };
		
		lkeylist = new Object();
		lkeylist.onKeyDown = Delegate.create(this, function() {
			if (Key.isDown(Key.LEFT)) {
				loadPrevious();
			}
		})
		
		rkeylist = new Object();
		rkeylist.onKeyDown = Delegate.create(this, function() {
			if (Key.isDown(Key.RIGHT)) {
				loadNext();
			}
		})
		
		infokeylist = new Object();
		infokeylist.onKeyDown = Delegate.create(this, function() {
			if ((Key.getAscii() == 105) or (Key.getAscii() == 73)) {
				toggleInfo();
			}
		});
		
		thumbskeylist = new Object();
		thumbskeylist.onKeyDown = Delegate.create(this, function() {
			if ((Key.getAscii() == 116) or (Key.getAscii() == 84)) {
				showThumbs();
			}
		})
		
		menukeylist = new Object();
		menukeylist.onKeyDown = Delegate.create(this, function() {
			if ((Key.getAscii() == 109) or (Key.getAscii() == 77)) {
				showMenu();
			}
		});
		
		liscount = setInterval(this, "initListeners", 100);
		
		menuarr = new Array();
	}
	
	/**
	 * Use this function to load the menu xml file into the gallery.
	 * @param	path - path to the xml file
	 */
	public function loadXML(path:String) {
		gal_xml.load(path);
	}
	
	private function initListeners() {
		if (_framesloaded == _totalframes) {
			MainMenu(menu_mc.content_mc).registerListener(this);
			
			ThumbList(thumblist_mc.content_mc).registerListener(this);
			
			init_list.ImageLoaded = Delegate.create(this, function(e:Object) {
				menu_mc._visible = true;
				ol_mc._visible = false;
				bg_mc.zoomEnabled = false;
				bg_mc.mouseScrollEnabled = false;
				menu_mc.content_mc.enable();
				Tweener.addTween(menu_mc, { _alpha:100, time:0.4, transition:"easeInOutQuad", onComplete:Delegate.create(this, function() {
					menu_mc.startScrolling();
				}) } );
				if ((basePath != SWFAddress.getValue()) and (SWFAddress.getValue() != "null")) {
					var mylen:Number = basePath.split("/").length;
					catID = SWFAddress.getValue().split("/")[mylen - 1];
					tempcatid = basePath;
					catxmlpath = MainMenu(menu_mc.content_mc).getXMLPath(catID);
					loadItem();
				}else {
					if (menuarr.length == 1) {
						MainMenu(menu_mc.content_mc).loadDefault();
					}else {
						MainMenu(menu_mc.content_mc).isActive = true;
						StageResized();
					}
				}
				bg_mc.removeEventListener("ImageLoaded", init_list);
				bg_mc.addEventListener("ImageLoaded", this);
				dispatchEvent( { type:"FirstImageLoaded" } );
			});
			bg_mc.addEventListener("ImageLoaded", init_list);
			
			clearInterval(liscount);
		};
	}
	
	private function processXML(success) {
		if (success) {
			scaletostage = gal_xml.firstChild.attributes.scaletostage;
			galheight = parseInt(gal_xml.firstChild.attributes.galheight);
			galwidth = parseInt(gal_xml.firstChild.attributes.galwidth);
			infoheight = parseInt(gal_xml.firstChild.attributes.infoheight);
			if (gal_xml.firstChild.attributes.zoom == "true")
			{
				zoomenabled = true;
			}else {
				zoomenabled = false;
			}
			if (gal_xml.firstChild.attributes.mousescroll == "true")
			{
				mousescroll = true;
			}else {
				mousescroll = false;
			}
			
			var title:String;
			var xmlfile:String;
			var myid:String;
			
			if (gal_xml.firstChild.childNodes.length == 1) {
				bmenu_mc.btns1_mc.menu_mc._visible = false;
				back_mc._visible = false;
			}else {
				bmenu_mc.btns1_mc.menu_mc._visible = true;
				back_mc._visible = true;
			}
			
			for (var i:Number = 0; i < gal_xml.firstChild.childNodes.length; i++) 
			{	
				var menuobj:Object = new Object();
				for (var j:Number = 0; j < gal_xml.firstChild.childNodes[i].childNodes.length; j++) 
				{
					if (gal_xml.firstChild.childNodes[i].childNodes[j].nodeName == "title") {
						title = gal_xml.firstChild.childNodes[i].childNodes[j].firstChild.nodeValue;
					}
					if (gal_xml.firstChild.childNodes[i].childNodes[j].nodeName == "xmlfile") {
						xmlfile = gal_xml.firstChild.childNodes[i].childNodes[j].firstChild.nodeValue;
					}
					if (gal_xml.firstChild.childNodes[i].childNodes[j].nodeName == "ID") {
						myid = gal_xml.firstChild.childNodes[i].childNodes[j].firstChild.nodeValue;
					}
				}
				menuobj.title = title;
				menuobj.xmlfile = xmlfile;
				menuobj.ID = myid;
				menuarr.push(menuobj);
			}
			MainMenu(menu_mc.content_mc).init(menuarr, gal_xml.firstChild.attributes.rows, gal_xml.firstChild.attributes.gap);
			StageResized();
			bg_mc.scaleMode = gal_xml.firstChild.attributes.scalemode;
			bg_mc.loadImage(gal_xml.firstChild.attributes.homeimg);
		}else {
			
		}
	}
	
	/**
	 * This function is basically a stage resize listener. Even if the gallery is configured to be of fixed width, this function is used to align the elements properly.
	 */
	public function StageResized() {
		if (scaletostage == "true") {
			
			ol_mc._width = Stage.width;
			ol_mc._height = Stage.height;
			
			themask_mc._width = Stage.width - galwidth;
			themask_mc._height = Stage.height - galheight;
			
			bmenu_mc.resize(Stage.width - galwidth);
			info_mc.resize(Stage.width - galwidth, infoheight);
			menu_mc.resize(Stage.width - galwidth, menu_mc.content_mc._height + 10);
			
			if (menu_mc.content_mc._width < Stage.width - galwidth) {
				menu_mc.content_mc._x = Math.round((Stage.width - galwidth - menu_mc.content_mc._width) / 2);
			}
			
			if (bmenu_mc._alpha == 50) {
				bmenu_mc._y = Stage.height - galheight + 3;
				bmenu_mc._alpha = 100;
			}
			
			if (isexam == true) {
				if (infovisible) {
					Tweener.addTween(bmenu_mc, { _y:(Stage.height - galheight - bmenu_mc.bg_mc._height - infoheight), time:0.4, transition:"easeOutQuart" } );
					Tweener.addTween(info_mc, { _y:(Stage.height - galheight - infoheight), time:0.4, transition:"easeOutQuart" } );
				}else {
					Tweener.addTween(bmenu_mc, { _y:(Stage.height - galheight - bmenu_mc.bg_mc._height), time:0.4, transition:"easeOutQuart" } );
					Tweener.addTween(info_mc, { _y:(Stage.height - galheight), time:0.4, transition:"easeOutQuart" } );
				}
			}else {
				Tweener.addTween(bmenu_mc, { _y:(System.capabilities.screenResolutionY - galheight + 3) , time:0.4, transition:"easeInQuart" } );
				Tweener.addTween(info_mc, { _y:(System.capabilities.screenResolutionY - galheight + 3 + bmenu_mc.bg_mc._height), time:0.4, transition:"easeInQuart" } );
			}
			
			if (thumblist_mc.content_mc.thumbWidth != undefined) {
				thumblist_mc._y = thumblist_mc.content_mc.thumbGap
				
				var tw:Number =  thumblist_mc.content_mc.colNum * thumblist_mc.content_mc.thumbWidth + (1 + thumblist_mc.content_mc.colNum) * thumblist_mc.content_mc.thumbGap + 1 * 10;
				
				thumblist_mc.resize(tw, Stage.height - galheight - 2*thumblist_mc.content_mc.thumbGap);
				thumblist_mc.bg_mc._width = 1 * tw + 1 * thumblist_mc.content_mc.thumbGap;
				thumblist_mc.bg_mc._height = Stage.height - galheight + 5;
				thumblist_mc.bg_mc._y = -thumblist_mc.content_mc.thumbGap - 2;
			}
			
			Tweener.addTween(back_mc, { _x:Math.round((Stage.width - galwidth - thumblist_mc.bg_mc._width)/2 - back_mc._width), time:0.4, delay:0.4, transition:"easeInOutQuart" } );
			
			if (ThumbList(thumblist_mc.content_mc).isActive == true) {
				Tweener.addTween(back_mc, { _y:(_ymouse - back_mc._height / 2), time:0.4, delay:0.6, transition:"easeOutQuad", onComplete:Delegate.create(this, function() {
					onEnterFrame = Delegate.create(this, function() {
						back_mc._y = _ymouse - back_mc._height / 2;
					});
				})});
				Tweener.addTween(thumblist_mc, { _x:Math.round((Stage.width - galwidth - thumblist_mc.bg_mc._width) / 2), time:0.4, delay:0.6, transition:"easeOutQuad" } );
			}else {
				delete onEnterFrame;
				Tweener.addTween(back_mc, { _y: -back_mc._height, time:0.4, delay:0.3, transition:"easeInQuart" } );
				Tweener.addTween(thumblist_mc, { _x:(System.capabilities.screenResolutionX - galwidth + 5), time:0.4, delay:0.3, transition:"easeInQuart" } );
			}
			if (MainMenu(menu_mc.content_mc).isActive == true) {
				Tweener.addTween(menu_mc, { _y:Math.round((Stage.height - galheight - menu_mc.content_mc._height) / 2) , time:0.3, delay:0.8, transition:"easeOutQuad", onComplete:Delegate.create(this, function() {
					menu_mc.startScrolling();
				}) } );
			}else {
				menu_mc.stopScrolling();
				Tweener.addTween(menu_mc, { _y: -(menu_mc.content_mc._height + 15), time:0.4, delay:0.1, transition:"easeInQuart" } );
			}
			
			if ((MainMenu(menu_mc.content_mc).isActive == true) or (ThumbList(thumblist_mc.content_mc).isActive == true)) {
				bg_mc.mouseScrollEnabled = false;
				bg_mc.zoomEnabled = false;
			}else {
				if (isexam)
				{
					bg_mc.mouseScrollEnabled = mousescroll;
					bg_mc.zoomEnabled = zoomenabled;
				}
			}
			
			bg_mc.resize(Stage.width - galwidth, Stage.height - galheight);
		}else {
			themask_mc._width = galwidth;
			themask_mc._height = galheight;
			
			bmenu_mc.resize(galwidth);
			menu_mc.resize(galwidth, menu_mc.content_mc._height + 10);
			if (menu_mc.content_mc._width < galwidth) {
				menu_mc.content_mc._x = Math.round((galwidth - menu_mc.content_mc._width) / 2);
			}
			if (MainMenu(menu_mc.content_mc).isActive == true) {
				Tweener.addTween(menu_mc, { _y:Math.round((galheight - menu_mc.content_mc._height) / 2) , time:0.3, delay:0.6, transition:"easeOutQuad", onComplete:Delegate.create(this, function() {
					menu_mc.startScrolling();
				}) } );
			}else {
				menu_mc.stopScrolling();
				Tweener.addTween(menu_mc, { _y: -menu_mc.content_mc._height - 15, time:0.3, transition:"easeOutQuad" } );
			}
			
			if (bmenu_mc._alpha == 50) {
				bmenu_mc._y = galheight + 3;
				bmenu_mc._alpha = 100;
			}
			
			if (isexam == true) {
				if (infovisible) {
					Tweener.addTween(bmenu_mc, { _y:(galheight - bmenu_mc.bg_mc._height - infoheight), time:0.4, transition:"easeOutQuart" } );
					Tweener.addTween(info_mc, { _y:(galheight - infoheight), time:0.4, transition:"easeOutQuart" } );
				}else {
					Tweener.addTween(bmenu_mc, { _y:(galheight - bmenu_mc.bg_mc._height), time:0.4, transition:"easeOutQuart" } );
					Tweener.addTween(info_mc, { _y:(galheight), time:0.4, transition:"easeOutQuart" } );
				}
			}else {
				Tweener.addTween(bmenu_mc, { _y:(galheight + 3) , time:0.4, transition:"easeInQuart" } );
				Tweener.addTween(info_mc, { _y:(galheight + 3+ bmenu_mc.bg_mc._height), time:0.4, transition:"easeInQuart" } );
			}
			
			if (isexam == true) {
				Tweener.addTween(bmenu_mc, { _y:(galheight - bmenu_mc.bg_mc._height), time:0.4, transition:"easeOutQuart" } );
			}else {
				Tweener.addTween(bmenu_mc, { _y:(galheight + 3) , time:0.4, transition:"easeOutQuart" } );
			}
			
			if (thumblist_mc.content_mc.thumbWidth != undefined) {
				thumblist_mc._y = thumblist_mc.content_mc.thumbGap
				var tw:Number = 2 * thumblist_mc.content_mc.thumbWidth + 4 * thumblist_mc.content_mc.thumbGap + 1*10 + 29;
				thumblist_mc.resize(tw, galheight - 2*thumblist_mc.content_mc.thumbGap);
				thumblist_mc.bg_mc._width = 1 * tw + 1 * thumblist_mc.content_mc.thumbGap;
				thumblist_mc.bg_mc._height = galheight + 5;
				thumblist_mc.bg_mc._y = -thumblist_mc.content_mc.thumbGap - 2;
			}
			
			Tweener.addTween(back_mc, { _x:Math.round((galwidth - thumblist_mc.bg_mc._width)/2 - back_mc._width), time:0.4, delay:0.4, transition:"easeInOutQuart" } );
			
			if (ThumbList(thumblist_mc.content_mc).isActive == true) {
				Tweener.addTween(back_mc, { _y:(_ymouse - back_mc._height / 2), time:0.4, delay:0.4, transition:"easeInOutQuart", onComplete:Delegate.create(this, function() {
					onEnterFrame = Delegate.create(this, function() {
						back_mc._y = _ymouse - back_mc._height / 2;
					});
				})});
				Tweener.addTween(thumblist_mc, { _x:Math.round((galwidth - thumblist_mc.bg_mc._width) / 2), time:0.4, delay:0.4, transition:"easeInOutQuart" } );
			}else {
				delete onEnterFrame;
				Tweener.addTween(back_mc, { _y: -back_mc._height, time:0.4, transition:"easeOutQuart" } );
				Tweener.addTween(thumblist_mc, { _x:(galwidth + 5), time:0.5, transition:"easeOutQuart" } );
			}
			
			if ((MainMenu(menu_mc.content_mc).isActive == true) or (ThumbList(thumblist_mc.content_mc).isActive == true)) {
				bg_mc.mouseScrollEnabled = false;
				bg_mc.zoomEnabled = false;
			}else {
				if (isexam)
				{
					bg_mc.mouseScrollEnabled = mousescroll;
					bg_mc.zoomEnabled = zoomenabled;
				}
			}
			
			bg_mc.resize(galwidth, galheight);
		}
	}
	
	private function loadImage(num:Number) {
		
		//isexam = true;
		
		currimg = num;
		
		if (currimg == ThumbList(thumblist_mc.content_mc).totalThumbs-1) {
			bmenu_mc.btns1_mc.next_mc.isEnabled = false;
			bmenu_mc.btns1_mc.prev_mc.isEnabled = true;
		}else {
			if (currimg == 0) {
				bmenu_mc.btns1_mc.prev_mc.isEnabled = false;
			}else {
				bmenu_mc.btns1_mc.prev_mc.isEnabled = true;
			}
			bmenu_mc.btns1_mc.next_mc.isEnabled = true;
		}
		
		ol_mc._visible = true;
		
		Key.removeListener(lkeylist);
		Key.removeListener(rkeylist);
		Key.removeListener(infokeylist);
		Key.removeListener(thumbskeylist);
		if (bmenu_mc.btns1_mc.menu_mc._visible == true) {
			Key.removeListener(menukeylist);
		}
		
		if (thumblist_mc.content_mc.imgType(num) == "image") {
			bg_mc.loadImage(thumblist_mc.content_mc.imgPath(num));
		}else {
			bg_mc.loadSWF(thumblist_mc.content_mc.imgPath(num));
		}
		
		StageResized()
	}
	
	public function loadNext() {
		if (currimg + 1 <= ThumbList(thumblist_mc.content_mc).totalThumbs - 1) {
			currimg += 1;
			SWFAddress.setValue(basePath + catID + "/" + thumblist_mc.content_mc.imgID(currimg) + "/");
		}		
	}
	
	public function loadPrevious() {
		if (currimg > 0) {
			currimg -= 1;
			SWFAddress.setValue(basePath + catID + "/" + thumblist_mc.content_mc.imgID(currimg) + "/");
		}
	}
	
	public function showInfo() {
		info_mc.setText(ThumbList(thumblist_mc.content_mc).imgTitle(currimg), ThumbList(thumblist_mc.content_mc).imgInfo(currimg));
		infovisible = true;
		if (scaletostage == "true") {
			Tweener.addTween(bmenu_mc, { _y:(Stage.height - galheight - bmenu_mc.bg_mc._height - infoheight), time:0.4, transition:"easeOutQuart" } );
			Tweener.addTween(info_mc, { _y:(Stage.height - galheight - infoheight), time:0.4, transition:"easeOutQuart" } );
		}else {
			Tweener.addTween(bmenu_mc, { _y:(galheight - bmenu_mc.bg_mc._height - infoheight), time:0.4, transition:"easeOutQuart" } );
			Tweener.addTween(info_mc, { _y:(galheight - infoheight), time:0.4, transition:"easeOutQuart" } );
		}
	}
	
	public function hideInfo() {
		infovisible = false;
		if (scaletostage == "true") {
			Tweener.addTween(bmenu_mc, { _y:(Stage.height - galheight - bmenu_mc.bg_mc._height), time:0.4, transition:"easeOutQuart" } );
			Tweener.addTween(info_mc, { _y:(Stage.height - galheight), time:0.4, transition:"easeOutQuart" } );
		}else {
			Tweener.addTween(bmenu_mc, { _y:(galheight - bmenu_mc.bg_mc._height), time:0.4, transition:"easeOutQuart" } );
			Tweener.addTween(info_mc, { _y:(galheight), time:0.4, transition:"easeOutQuart" } );
		}
	}
	
	public function toggleInfo() {
		if (infovisible) {
			hideInfo();
		}else {
			showInfo();
		}
	}
	
	public function showThumbs() {
		SWFAddress.setValue(basePath + catID + "/");
	}
	
	public function showMenu() {
		tempcatid = undefined;
		SWFAddress.setValue(basePath);
	}
	
	public function exit() {
		Key.removeListener(lkeylist);
		Key.removeListener(rkeylist);
		Key.removeListener(infokeylist);
		Key.removeListener(thumbskeylist);
		if (bmenu_mc.btns1_mc.menu_mc._visible == true) {
			Key.removeListener(menukeylist);
		}
		super.exit();
	}
	
	private function loadItem() {
		//gen_txt.text = SWFAddress.getValue();
		if (SWFAddress.getValue() != basePath) {
			if (tempcatid != catID) {
				catID = tempcatid;
				//trace(ThumbList(thumblist_mc.content_mc).isActive);
				//thumblist_mc.content_mc.isActive = true;
				menu_mc.content_mc.isActive = false;
				isexam = false;
				Key.removeListener(thumbskeylist);
				Key.removeListener(lkeylist);
				Key.removeListener(rkeylist);
				StageResized();
				ThumbList(thumblist_mc.content_mc).loadXML(catxmlpath);
			}else {
				if (SWFAddress.getValue() == basePath + catID + "/") {
					thumblist_mc.content_mc.isActive = true;
					menu_mc.content_mc.isActive = false;
					isexam = false;
					Key.removeListener(thumbskeylist);
					Key.removeListener(lkeylist);
					Key.removeListener(rkeylist);
					StageResized();
				}else {
					thumblist_mc.content_mc.isActive = false;
					menu_mc.content_mc.isActive = false;
					loadImage(currimg);
				}
			}
		}else {
			thumblist_mc.content_mc.isActive = false;
			menu_mc.content_mc.isActive = true;
			isexam = false;
			Key.removeListener(thumbskeylist);
			Key.removeListener(lkeylist);
			Key.removeListener(rkeylist);
			if (bmenu_mc.btns1_mc.menu_mc._visible == true) {
				Key.removeListener(menukeylist);
			}
			StageResized();
		}
	}

	/******
	 * Below are a set of listener methods
	 * ********/
	
	private function MainMenuInit(e:Object) {
		SWFAddress.addEventListener(SWFAddressEvent.CHANGE, Delegate.create(this, function() {
			loadItem();
		}));
	}
	
	private function MenuItemClicked(e:Object) {
		tempcatid = e.ID;
		catxmlpath = e.xmlpath;
		SWFAddress.setValue(basePath + e.ID + "/");
		//gen_txt.text = "dasda";
		StageResized();
	}
	
	private function ThumbListInit(e:Object) {
		thumblist_mc._alpha = 100;
		thumblist_mc._visible = true;
		//trace(ThumbList(thumblist_mc.content_mc).isActive);
		if (SWFAddress.getValue() != "null") {
			currimg = ThumbList(thumblist_mc.content_mc).imgPathByID(SWFAddress.getValue().split("/")[basePath.split("/").length]);
			if (currimg != -1) {
				loadItem();
			}else {
				StageResized();
			}
			catID = tempcatid = SWFAddress.getValue().split("/")[basePath.split("/").length-1];
		}
	}
	
	private function ThumbClicked(e:Object) {
		currimg = e.loadObj.num;
		SWFAddress.setValue(basePath + catID + "/" + e.loadObj.ID + "/");
	}
	
	private function ImageLoaded() {
		
		isexam = true;
		bg_mc.zoomEnabled = zoomenabled;
		bg_mc.mouseScrollEnabled = mousescroll;
		
		ol_mc._visible = false;
		
		if (currimg > 0) {
			Key.addListener(lkeylist);
		}else {
			Key.removeListener(lkeylist);
		}
		
		if (currimg < thumblist_mc.content_mc.totalThumbs-1) {
			Key.addListener(rkeylist);
		}else {
			Key.removeListener(rkeylist);
		}
		
		if (ThumbList(thumblist_mc.content_mc).imgTitle(currimg) != undefined) {
			Key.addListener(infokeylist);
			bmenu_mc.btns1_mc.info_mc.isEnabled = true;
			if (infovisible == true or infovistemp == true) {
				showInfo();
				infovistemp = false;
			}
		}else {
			Key.removeListener(infokeylist);
			bmenu_mc.btns1_mc.info_mc.isEnabled = false;
			if (infovisible) {
				infovistemp = true;
			}
			hideInfo();
		}
		
		Key.addListener(thumbskeylist);
		
		if (bmenu_mc.btns1_mc.menu_mc._visible == true) {
			Key.addListener(menukeylist);
		}
		
		if (infovisible) {
			info_mc.setText(ThumbList(thumblist_mc.content_mc).imgTitle(currimg), ThumbList(thumblist_mc.content_mc).imgInfo(currimg));
		}
		StageResized();
		dispatchEvent( { type:"ImageLoaded" } );
	}
	
	public function get zoomEnabled():Boolean
	{
		return zoomenabled;
	}
}