﻿import template.TemplateDisplayObject;
import template.GlobalVars;
import imagegal.XMLImageGallery;
import caurina.transitions.*;
import mx.utils.Delegate;

/**
 * This class implements the functionality of the gallery. It encapsulates the XML Image Gallery.<br/><br/>
 * The following events are dispatched by this class:<br/><br/>
 * <b><i>DisplayObjectInit</i></b> - dispatched when the gallery's <i>init</i> function is done executing.<br/><br/>
 * <b><i>DisplayObjectEnter</i></b> - dispatched when the gallery's <i>enter</i> function is done executing.<br/><br/>
 * <b><i>DisplayObjectExit</i></b> - dispatched afer the <i>exit</i> function of the gallery is done executing.<br/><br/>
 */
class template.Gallery extends TemplateDisplayObject
{
	
	private var gal_mc:XMLImageGallery
	private var bg_mc:MovieClip;
	private var close_mc:MovieClip;
	private var ins_mc:MovieClip;
	private var ins1_mc:MovieClip;
	
	private var keylist:Object;
	private var gen_txt:TextField;
	
	public function Gallery() 
	{
		
	}
	
	/**
	 * Use this method to register a movieclip as this class
	 * @param	target - the movieclip to be registered
	 */
	public static function main(target:MovieClip) {
		target.__proto__ = Gallery.prototype;
		target.init();
	}
	
	/**
	 * Method used to initialize all the variables, functionality, etc.
	 */
	public function init() {
		bg_mc.onRelease = function(){};
		
		bg_mc.useHandCursor = false;
		
		Stage.addListener(this);
		
		close_mc.onRelease = Delegate.create(this, function() {
			exit();
		});
		
		gal_mc.addEventListener("ImageLoaded", this);
		
		keylist = new Object();
		keylist.onKeyDown = Delegate.create(this, function() {
			if (Key.getCode() == 72) {
				if (gal_mc.zoomEnabled)
				{
					ins_mc._visible = true;
					Tweener.addTween(ins_mc, { _alpha:100, time:0.4, transition:"easeInQuad" } );
				}else {
					ins1_mc._visible = true;
					Tweener.addTween(ins1_mc, { _alpha:100, time:0.4, transition:"easeInQuad" } );
				}
			}
		})
		
		ins_mc.close_mc.onRelease = Delegate.create(this, function(){
			Tweener.addTween(ins_mc, { _alpha:0, time:0.4, transition:"easeInQuad", onComplete:Delegate.create(this, function() {
				ins_mc._visible = false;
			}) } );
		});
		
		ins1_mc.close_mc.onRelease = Delegate.create(this, function(){
			Tweener.addTween(ins1_mc, { _alpha:0, time:0.4, transition:"easeInQuad", onComplete:Delegate.create(this, function() {
				ins1_mc._visible = false;
			}) } );
		});
		
		ins_mc._visible = false;
		
		ins1_mc._visible = false;
		
		enter();
		
		super.init();
	}
	
	/**
	 * Use this property to set the xml file of the gallery.
	 */
	public function set xmlFile(path:String) {
		gal_mc.loadXML(path);
	}
	
	public function set basePath(str:String) {
		_basePath = str;
		gal_mc.basePath = str;
	}
	
	/**
	 * Call this function to make the gallery appear.
	 */
	public function enter() {
		bg_mc._height = Stage.height;
		bg_mc._width = 0;
		bg_mc._alpha = 100;
		
		Tweener.addTween(bg_mc, { _width:Stage.width, time:(Stage.width/1000)*0.4, transition:"easeInOutQuart", delay:0.3, onComplete:Delegate.create(this, function() {
			Tweener.addTween(close_mc, { _x:0, time:0.3, transition:"easeInOutQuart", delay:0.1 } );
			onResize();
			Key.addListener(keylist);
			super.enter();
			//xmlFile = "xml/objects.xml";
			//ins_mc.play();
		}) } );
	}
	
	/**
	 * Call this function for the exit transition of the gallery.
	 */
	public function exit() {
		gal_mc.exit();
		Key.removeListener(keylist);
		Tweener.addTween(close_mc, { _x:( -close_mc._width - 2), time:0.3, transition:"easeInOutQuart", delay:0.1 } );
		Tweener.addTween(ins_mc, { _alpha:0, time:(Stage.width / 1000) * 0.4, transition:"easeInQuad", delay:0.3 } );
		Tweener.addTween(ins1_mc, { _alpha:0, time:(Stage.width / 1000) * 0.4, transition:"easeInQuad", delay:0.3 } );
		Tweener.addTween(gal_mc, { _alpha:0, time:(Stage.width/1000)*0.4, transition:"easeInQuad", delay:0.3, onComplete:Delegate.create(this, function() {
			Tweener.addTween(bg_mc, { _width:0, time:(Stage.width/1000)*0.4, transition:"easeInOutQuart", delay:0.2, onComplete:Delegate.create(this, function() {
				bg_mc._alpha = 0;
				super.exit();
			}) } );
		})});
	}
	
	
	private function onResize() {
		bg_mc._width = Stage.width;
		bg_mc._height = Stage.height;
		
		ins_mc._x = Stage.width/2;
		ins_mc._y = Stage.height / 2;
		
		ins1_mc._x = Stage.width/2;
		ins1_mc._y = Stage.height / 2;
	}
	
	private function ImageLoaded() {
		if (gal_mc.zoomEnabled) {
			if (!GlobalVars.GalleryInstructions1Displayed)
			{
				ins_mc._visible = true;
				Tweener.addTween(ins_mc, { _alpha:100, time:0.4, transition:"easeInQuad", delay:0.3 } );
				GlobalVars.GalleryInstructions1Displayed = true;
				gal_mc.removeEventListener("FirstImageLoaded");
			}
		}else {
			if (!GlobalVars.GalleryInstructions2Displayed)
			{
				ins1_mc._visible = true;
				Tweener.addTween(ins1_mc, { _alpha:100, time:0.4, transition:"easeInQuad", delay:0.3 } );
				GlobalVars.GalleryInstructions2Displayed = true;
				gal_mc.removeEventListener("FirstImageLoaded");
			}
		}
	}
	
}