﻿import template.TemplateDisplayObject;
import template.GlobalVars;
import imagegal.XMLImageGallery;
import caurina.transitions.*;
import mx.utils.Delegate;
import com.maheshj.utils.IXML;

/**
 * This class implements the functionality of the client login section. It encapsulates the XML Image Gallery, but won't display it until the user is authenticated.
 * The following events are dispatched by this class:<br/><br/>
 * <b><i>DisplayObjectInit</i></b> - dispatched when the gallery's <i>init</i> function is done executing.<br/><br/>
 * <b><i>DisplayObjectEnter</i></b> - dispatched when the gallery's <i>enter</i> function is done executing.<br/><br/>
 * <b><i>DisplayObjectExit</i></b> - dispatched afer the <i>exit</i> function of the gallery is done executing.<br/><br/>
 */
class template.LoginGallery extends TemplateDisplayObject
{
	
	private var galleries_xml:XML;
	private var gal_mc:XMLImageGallery
	private var bg_mc:MovieClip;
	private var close_mc:MovieClip;
	private var login_mc:MovieClip;
	private var success_txt:TextField;
	private var form_mc:MovieClip;
	private var submit_mc:MovieClip;
	private var inv_mc:MovieClip;
	private var ins_mc:MovieClip;
	private var ins1_mc:MovieClip;
	private var keylist:Object;
	
	public function LoginGallery() 
	{
		
	}
	
	/**
	 * Use this method to register a movieclip as this class
	 * @param	target - the movieclip to be registered
	 */
	public static function main(target:MovieClip) {
		target.__proto__ = LoginGallery.prototype;
		target.init();
	}
	
	/**
	 * Method used to initialize all the variables, functionality, etc.
	 */
	public function init() {
		
		success_txt._visible = false;
		
		bg_mc.onRelease = function(){};
		
		bg_mc.useHandCursor = false;
		
		Stage.addListener(this);
		
		close_mc.onRelease = Delegate.create(this, function() {
			exit();
		});
		
		gal_mc.addEventListener("ImageLoaded", this);
		
		inv_mc.onRollOver = Delegate.create(this, function() {
			Tweener.addTween(inv_mc, { _x:-28, time:0.2, transition:"easeOutQuad" } );
		
			Tweener.addTween(submit_mc, { _x: -28, time:0.2, transition:"easeOutQuad", onComplete:Delegate.create(this, function() {
				Tweener.addTween(form_mc, { _x:0, time:0.3, transition:"easeOutQuart" } );
			}) } );
		});
		
		keylist = new Object();
		keylist.onKeyDown = Delegate.create(this, function() {
			if (Key.getCode() == 72) {
				if (gal_mc.zoomEnabled)
				{
					ins_mc._visible = true;
					Tweener.addTween(ins_mc, { _alpha:100, time:0.4, transition:"easeInQuad" } );
				}else {
					ins1_mc._visible = true;
					Tweener.addTween(ins1_mc, { _alpha:100, time:0.4, transition:"easeInQuad" } );
				}
			}
		})
		
		ins_mc.close_mc.onRelease = Delegate.create(this, function(){
			Tweener.addTween(ins_mc, { _alpha:0, time:0.4, transition:"easeInQuad", onComplete:Delegate.create(this, function() {
				ins_mc._visible = false;
			}) } );
		});
		
		ins1_mc.close_mc.onRelease = Delegate.create(this, function(){
			Tweener.addTween(ins1_mc, { _alpha:0, time:0.4, transition:"easeInQuad", onComplete:Delegate.create(this, function() {
				ins1_mc._visible = false;
			}) } );
		});
		
		ins_mc._visible = false;
		
		ins1_mc._visible = false;
		
		form_mc.mes_txt.condenseWhite = true;
		
		form_mc.bg_mc.useHandCursor = false;
		
		form_mc.bg_mc.onRollOver = function() { };
		
		form_mc.close_mc.onRelease = Delegate.create(this, function() {
			Tweener.addTween(form_mc, { _x: -396, time:0.3, transition:"easeInQuad", onComplete:Delegate.create(this, function() {
				
				Tweener.addTween(inv_mc, { _x:0, time:0.2, transition:"easeOutQuad" } );
		
				Tweener.addTween(submit_mc, { _x:0, time:0.2, transition:"easeOutQuad" } );
			}) } );
		});
		
		form_mc.mes_txt.onSetFocus = Delegate.create(this, function() {
			if (form_mc.mes_txt.text.substr(0,7) == "MESSAGE") {
				form_mc.mes_txt.text = "";
			}
		});
		
		form_mc.mes_txt.onKillFocus = Delegate.create(this, function() {
			if (form_mc.mes_txt.text == "") {
				form_mc.mes_txt.text = "MESSAGE";
			}
		});
		
		form_mc.reset_mc.onRelease = Delegate.create(this, function() {
			form_mc.mes_txt.text = "MESSAGE";
		});
		
		form_mc.send_mc.onRelease = Delegate.create(this, function() {
			if (form_mc.mes_txt.text.substr(0,7) == "MESSAGE" or form_mc.mes_txt.text == " ") {
				form_mc.status_txt.text = "Please enter a message";
				return;
			}
			var email:String = form_mc.email_txt.text.split(": ")[1];
			if ((email.length<6) || (email.indexOf(",")>=0) || (email.indexOf(";")>=0) || (email.indexOf(":")>=0) || (email.indexOf("/")>=0) || (email.indexOf(" "	)>=0) || (email.indexOf("@")<=0) || (email.indexOf("@") != email.lastIndexOf("@")) || (email.lastIndexOf(".")<email.indexOf("@")) || ((email.lastIndexOf(".")+3)>email.length)) {
				form_mc.status_txt.text = "Your email address is not valid";
				return;
			}
			form_mc.status_txt.text = "Sending message. Please wait";
			loadVariables("clientemail.php?name=" + form_mc.name_txt.text.split(": ")[1] + "&email=" + form_mc.email_txt.text.split(": ")[1] + "&message=" + form_mc.mes_txt.text, this, "GET");
			this.onData = function() {
				if(this.result.substr(0,6) != "failed"){
					form_mc.status_txt.text = "Message successfully sent";
				} else {
					form_mc.status_txt.text = "Error sending message. Please try again";
				}
			};
		});
		
		enter();
		
		super.init();
	}
	
	/**
	 * Use this property to set the xml file of the gallery.
	 */
	public function set xmlFile(path:String) {
		gal_mc.loadXML(path);
	}
	
	public function set basePath(str:String) {
		_basePath = str;
		gal_mc.basePath = str;
	}
	
	/**
	 * Call this function to make the gallery appear. Called during the "in" transition for the gallery.
	 */
	public function enter() {
		bg_mc._height = Stage.height;
		bg_mc._width = 0;
		bg_mc._alpha = 100;
		
		Tweener.addTween(bg_mc, { _width:Stage.width, time:(Stage.width / 1000) * 0.4, transition:"easeInOutQuart", delay:0.3, onComplete:Delegate.create(this, function() {
			Tweener.addTween(close_mc, { _x:0, time:0.3, transition:"easeInOutQuart", delay:0.1 } );
			onResize();
			login_mc.play();
			super.enter();
		}) } );
	}
	
	/**
	 * Call this function for the exit transition of the gallery.  Called during the "out" transition for the gallery.
	 */
	public function exit() {
		Tweener.addTween(close_mc, { _x:( -close_mc._width - 2), time:0.3, transition:"easeInOutQuart", delay:0.1 } );
		Tweener.addTween(login_mc, { _x: -(login_mc._width + 5), time:0.6, transition:"easeInOutQuart", delay:0.3 } );
		Tweener.addTween(inv_mc, { _x: -(inv_mc._width + 5), time:0.3, transition:"easeInQuad", delay:0.3 } );
		Tweener.addTween(submit_mc, { _x: -(submit_mc._width + 5), time:0.3, transition:"easeInQuad", delay:0.3 } );
		Tweener.addTween(form_mc, { _x: -(form_mc._width + 5), time:0.3, transition:"easeInQuad", delay:0.3 } );
		Tweener.addTween(ins_mc, { _alpha:0, time:(Stage.width / 1000) * 0.4, transition:"easeInQuad", delay:0.3 } );
		Tweener.addTween(ins1_mc, { _alpha:0, time:(Stage.width / 1000) * 0.4, transition:"easeInQuad", delay:0.3 } );
		Tweener.addTween(gal_mc, { _alpha:0, time:(Stage.width / 1000) * 0.4, transition:"easeInQuad", delay:0.3, onComplete:Delegate.create(this, function() {
			Tweener.addTween(bg_mc, { _width:0, time:(Stage.width/1000)*0.4, transition:"easeInOutQuart", delay:0.2, onComplete:Delegate.create(this, function() {
				bg_mc._alpha = 0;
				super.exit();
			}) } );
		})});
	}
	
	/**
	 * Stage listener
	 */
	private function onResize() {
		bg_mc._width = Stage.width;
		bg_mc._height = Stage.height;
		
		login_mc._x = Math.round(Stage.width / 2);
		login_mc._y = Math.round(Stage.height / 2);
		
		success_txt._x = Math.round((Stage.width - success_txt._width) / 2);
		success_txt._y = Math.round((Stage.height - success_txt._height) / 2);
		
		ins_mc._x = Stage.width/2;
		ins_mc._y = Stage.height / 2;
		
		ins1_mc._x = Stage.width/2;
		ins1_mc._y = Stage.height / 2;
	}
	
	/**
	 * Executed when the user is validated
	 * @param	e - the event object
	 */
	private function UserValidated(e:Object) {
		success_txt._visible = true;
		
		galleries_xml = IXML.createXML();
		
		galleries_xml.ignoreWhite = true;
		
		form_mc.name_txt.text = "NAME: " + e.user.details.split("/")[0].split(":")[1];
		
		form_mc.email_txt.text = "E-MAIL: " + e.user.details.split("/")[1].split(":")[1];
		
		Tweener.addTween(inv_mc, { _x:0, time:0.2, transition:"easeOutQuad" } );
		
		Tweener.addTween(submit_mc, { _x:0, time:0.2, transition:"easeOutQuad" } );
		
		galleries_xml.onLoad = Delegate.create(this, function(success) {
			var found:Boolean = false;
			var tempstr:String = galleries_xml.toString();
			tempstr = replacestr(tempstr, "&gt;", ">");
			tempstr = replacestr(tempstr, "&lt;", "<");
			tempstr = replacestr(tempstr, "&quot;", "\"");
			if (tempstr.substr(0, 15) == "<encryptedtext>") {
				tempstr = tempstr.substr(15, tempstr.length-31);
				galleries_xml = new XML(EncryptDecrypt.decrypt(tempstr));
				galleries_xml.ignoreWhite = true;
			}
			for (var i:Number = 0; i < galleries_xml.firstChild.childNodes.length; i++) 
			{
				if (e.user.username == galleries_xml.firstChild.childNodes[i].attributes.username) {
					xmlFile = galleries_xml.firstChild.childNodes[i].attributes.xmlfile;
					found = true;
					success_txt._visible = false;
					return;
				}
			}
			if (!found) {
				success_txt.text = "ERROR LOADING GALLERY";
			}
		});
		galleries_xml.load("xml/clientgalleries.xml");
	}
	
	private function replacestr(str:String, rep:String, rep1:String):String {
		return str.split(rep).join(rep1);
	}
	
	private function ImageLoaded() {
		if (gal_mc.zoomEnabled) {
			if (!GlobalVars.GalleryInstructions1Displayed)
			{
				ins_mc._visible = true;
				Tweener.addTween(ins_mc, { _alpha:100, time:0.4, transition:"easeInQuad", delay:0.3 } );
				GlobalVars.GalleryInstructions1Displayed = true;
				gal_mc.removeEventListener("FirstImageLoaded");
			}
		}else {
			if (!GlobalVars.GalleryInstructions2Displayed)
			{
				ins1_mc._visible = true;
				Tweener.addTween(ins1_mc, { _alpha:100, time:0.4, transition:"easeInQuad", delay:0.3 } );
				GlobalVars.GalleryInstructions2Displayed = true;
				gal_mc.removeEventListener("FirstImageLoaded");
			}
		}
	}
	
}