﻿import com.maheshj.UI.core.GenericMenu;
import mx.events.EventDispatcher;
import mx.utils.Delegate;
import com.maheshj.utils.IXML;
import template.MainMenuManager;
import caurina.transitions.*;

/**
 * This is the main menu class for the template.<br/><br/>The following events are dispatched by this class:<br/><br/>
 * <b><i>MenuItemClicked</i></b> - dispatched when the a menu item is clicked. It's event object has all the properties put in the menu's XML file for that particular item<br/><br/>
 * <b><i>MainMenuInit</i></b> - dispatched afer the initialization the menu items<br/><br/>
 */
class template.MainMenu extends GenericMenu
{
	private var bg_mc:MovieClip;
	
	private static var EventDispatcherDependancy = EventDispatcher.initialize(MainMenu.prototype);
	
	public function MainMenu()
	{	
		manager = new MainMenuManager(this);
	}
	
	private function createMenu() {
		
		var newx:Number = gap;
		var my_mc:MovieClip;
		
		for (var i:Number = 0; i < menuarr.length; i++) 
		{
			my_mc = attachMovie("mainmenuitem", "item" + i + "_mc", i + 10, { _alpha:0, enabled:false, _y:3 } );
			my_mc.addEventListener("MenuItemClicked", this);
		}
		
		for (i = 0; i < menuarr.length; i++) 
		{
			if (menuarr[i].isdefault == "true") {
				_hasdefault = true;
			}
			this["item" + i + "_mc"].init(menuarr[i]);
			this["item" + i + "_mc"]._x = newx;
			newx += this["item" + i + "_mc"]._width + 1*gap;
		}
		
		bg_mc._width = getDimensions().width + 70;
		bg_mc._x = -bg_mc._width;
		
		dispatchEvent( { type:"MainMenuInit" } );
	}
	
	/**
	 * Use this function to enable all the items of the menu.
	 */
	public function enable() {
		Tweener.addTween(bg_mc, { _x:0, time:0.6, transition:"easeOutQuint", onComplete:Delegate.create(this, function() {
			for (var i:Number = 0; i < menuarr.length; i++) 
			{
				this["item" + i + "_mc"].enabled = true;
			}
		}) } );
	}
	
	public function disable() {
		for (var i:Number = 0; i < menuarr.length; i++) 
			{
				this["item" + i + "_mc"].enabled = false;
			}
	}
	
	public function set visible(bool:Boolean) {
		if (bool) {
			for (var i:Number = 0; i < menuarr.length; i++) 
			{
				Tweener.addTween(this["item" + i + "_mc"], {_alpha:100, time:0.35, transition:"easeInQuad", delay:0.1*i});
			}
		}else {
			for (var i:Number = menuarr.length-1; i < 0; i--) 
			{
				Tweener.addTween(this["item" + i + "_mc"], {_alpha:0, time:0.35, transition:"easeInQuad", delay:0.1*i});
			}
		}
		_vis = bool;
	}
	
	public function getLinkByNum(num:Number) {
		
	}
	
}