﻿import com.maheshj.UI.core.DisplayObject;
import com.maheshj.UI.core.GenericMenu;
import com.maheshj.UI.core.GenericMenuManager;
import template.MenuItemInitData;

/**
 * This class is used as a way to decouple the XML processing and other functions that are subject to change in the future versions.
 */
class template.MainMenuManager extends GenericMenuManager
{
	
	/**
	 * The constructor
	 * @param	menu - the menu object
	 */
	public function MainMenuManager(menu:GenericMenu) 
	{
		super(menu);
	}
	
	/**
	 * Call this function to process the menu XML data loaded from an XML file.
	 * @param	menu_xml - the XML data loaded into the menu
	 * @return - an array containing the menu item data
	 */
	public function processXML(menu_xml:XML):Array {
		menu_mc.itemGap = parseInt(menu_xml.firstChild.attributes.gap);
		var menuarr:Array = new Array();
		for (var i:Number = 0; i < menu_xml.firstChild.childNodes.length; i++) 
		{
			var initObj:MenuItemInitData = new MenuItemInitData();
			for (var j:Number = 0; j < menu_xml.firstChild.childNodes[i].childNodes.length; j++) 
			{
				initObj[menu_xml.firstChild.childNodes[i].childNodes[j].nodeName] = menu_xml.firstChild.childNodes[i].childNodes[j].firstChild.nodeValue;
			}
			if (initObj.inflash != "false") {
				menuarr.push(initObj);
			}
		}
		return menuarr;
	}
	
}