﻿import com.maheshj.UI.core.Dimensions;
import com.maheshj.utils.ContentLoader;
import template.TemplateDisplayObject;
import caurina.transitions.*;
import mx.utils.Delegate;

/**
 * This class serves as an 'adapter' class that manages the loading, unloading, intro and outro of the externally loaded SWF files.<br/><br/>The following events are dispatched by this class:<br/><br/>
 * <b><i>DisplayObjectInit</i></b> - dispatched when the loaded SWF file has been initialized.<br/><br/>
 * <b><i>DisplayObjectEnter</i></b> - dispatched when the loaded SWF file has executed its <i>enter</> function.<br/><br/>
 * <b><i>DisplayObjectExit</i></b> - dispatched when the loaded SWF file has executed its <i>exit</> function.<br/><br/>
 */
class template.Page extends TemplateDisplayObject
{
	
	private var page_cl:ContentLoader;
	private var holder_mc:TemplateDisplayObject;
	private var currscaleindex:Number;
	private var pl_mc:MovieClip;
	private var loaded:Boolean;
	private var loading:Boolean;
	
	private var currstate:String;
	private var holderxml:String;
	private var _iscustom:Boolean;
	
	/**
	 * The constructor.
	 */
	public function Page() 
	{
		loaded = false;
		
		loading = false;
		
		page_cl = new ContentLoader();
		
		page_cl.onLoadStart = Delegate.create(this, function() {
			loading = true;
			loaded = false;
		});
		
		page_cl.onLoadProgress = Delegate.create(this, function(target:MovieClip, bl:Number, bt:Number) {
			pl_mc.progress_mc.progress_txt.text = "LOADING... " + Math.round((bl / bt) * 100) + "%";
		});
		
		page_cl.onLoadInit = Delegate.create(this, function() {
			pl_mc.gotoAndPlay("out");
			onEnterFrame = Delegate.create(this, function() {
				holder_mc.addEventListener("DisplayObjectInit", this);
				holder_mc.init();
				holder_mc.addEventListener("DisplayObjectEnter", this);
				holder_mc.addEventListener("DisplayObjectExit", this);
				loaded = true;
				loading = false;
				delete onEnterFrame;
			});
			if (_iscustom) {
				Tweener.addTween(holder_mc, { _alpha:100, transition:"easeInQuad", time:0.35 } );
			}
		});
	}
	
	/**
	 * Call this function to load an external SWF file into it.
	 * @param	str - the path of the SWF file to be loaded
	 */
	public function loadFile(str:String) {
		if (_iscustom) {
			holder_mc._alpha = 0;
		}else {
			holder_mc._alpha = 100;
		}
		pl_mc._x = -_x;
		pl_mc.gotoAndPlay("in");
		var count:Number = 0;
		onEnterFrame = Delegate.create(this, function() {
			if (pl_mc._currentframe == 10) {
				page_cl.loadContent(str, holder_mc);
				delete onEnterFrame;
			}
		});
	}
	
	public function exit() {
		if (loaded) {
			if (!_iscustom) {
				holder_mc.exit();
			}else {
				Tweener.addTween(holder_mc, { _alpha:0, transition:"easeInQuad", time:0.35, onComplete:Delegate.create(this, function() {
					DisplayObjectExit();
				}) } );
			}
		}else {
			DisplayObjectExit();
		}
	}
	
	/**
	 * Use this property to set the XML file that is to be loaded once an external file is done loading.
	 */
	public function set xmlFile(path:String) {
		holderxml = path;
	}
	
	public function set isCustom(bool:Boolean) {
		_iscustom = bool;
	}
	
	private function DisplayObjectInit(e:Object) {
		currstate = "init";
		dispatchEvent( { type:"DisplayObjectInit" } );
		holder_mc.enter();
	}
	
	private function DisplayObjectEnter(e:Object) {
		currstate = "enter";
		holder_mc.basePath = basePath;
		if (holderxml != undefined) {
			holder_mc.xmlFile = holderxml;
			holder_mc.loadXML();
		}
		dispatchEvent( { type:"DisplayObjectEnter" } );
	}
	
	private function DisplayObjectExit(e:Object) {
		holder_mc.unloadMovie();
		if (loading) {
			pl_mc.gotoAndPlay("out");
		}
		holder_mc._alpha = 100;
		loaded = false;
		loading = false;
		currstate = "exit";
		dispatchEvent( { type:"DisplayObjectExit" } );
	}
	
}