﻿import com.maheshj.UI.core.DisplayObject;
import caurina.transitions.*;
import mx.utils.Delegate;

/**
 * This class forms the "HOME" section of the template. Basically it implements a 'text' slideshow of quotes placed in an XML file.<br/><br/>
 * The following events are dispatched by this class:<br/><br/>
 * <b><i>DisplayObjectInit</i></b> - dispatched when the class's <i>init</i> function is done executing.<br/><br/>
 * <b><i>DisplayObjectEnter</i></b> - dispatched when the class's <i>enter</i> function is done executing.<br/><br/>
 * <b><i>DisplayObjectExit</i></b> - dispatched afer the <i>exit</i> function of the class is done executing.<br/><br/>
 */
class template.PhotogQuotes extends DisplayObject
{
	private var quotes_mc:MovieClip;
	private var quotearr:Array;
	private var interval:Number;
	private var intervalid:Number;
	private var currquote:Number;
	private var controls_mc:MovieClip;
	private var isplaying:Boolean;
	
	public function PhotogQuotes() 
	{
		
	}
	
	/**
	 * Use this method to register a movieclip as this class
	 * @param	target - the movieclip to be registered
	 */
	public static function main(target:MovieClip) {
		target.__proto__ = PhotogQuotes.prototype;
		target.init();
	}
	
	/**
	 * Method used to initialize all the variables, functionality, etc.
	 */
	public function init() {
		
		quotes_mc.text_txt._alpha = 0;
		quotes_mc.text_txt.autoSize = true;
		var my_fmt:TextFormat = new TextFormat();
		my_fmt.rightMargin = 20;
		quotes_mc.text_txt.setNewTextFormat(my_fmt);
		
		quotes_mc.line_mc._width = 1;
		
		currquote = -1;
		
		quotearr = new Array();
		
		quotes_mc.controls_mc.prev_mc.onRelease = Delegate.create(this, function() {
			currquote = currquote - 1;
			if (currquote < 0) {
				currquote = quotearr.length - 1;
			}
			if (isplaying) {
				stopShow();
				startShow();
			}
			changeQuote();
		});
		
		quotes_mc.controls_mc.playpause_mc.onRelease = Delegate.create(this, function() {
			if (isplaying) {
				stopShow();
				quotes_mc.controls_mc.playpause_mc.gotoAndStop(2);
				isplaying = false;
			}else {
				startShow();
				quotes_mc.controls_mc.playpause_mc.gotoAndStop(1);
				isplaying = true;
			}
		});
		
		quotes_mc.controls_mc.next_mc.onRelease = Delegate.create(this, function() {
			loadNext();
			if (isplaying) {
				stopShow();
				startShow();
			}
		});
		
		Stage.addListener(this);
		
		super.init();
		//enter();
	}
	
	/**
	 * Call this function to make the quotes appear in the beggining.
	 */
	public function enter() {
		onResize();
		quotes_mc._alpha = 100;
		Tweener.addTween(quotes_mc.line_mc, { _width:(Stage.width - 250), time:0.6, transition:"easeInOutQuint" } );
		Tweener.addTween(quotes_mc.bg_mc, { _width:(Stage.width - 250), time:0.6, transition:"easeInOutQuint", onComplete:Delegate.create(this, function() {
			super.enter();
		}) } );
	}
	
	/**
	 * Call this function for the exit transition of the quotes.
	 */
	public function exit() {
		delete onResize;
		clearInterval(intervalid);
		Tweener.addTween(quotes_mc, { _x:(Stage.width + quotes_mc._width) , time:0.7, transition:"easeInOutQuint", onComplete:Delegate.create(this, function() {
			super.exit();
		}) } );
	}
	
	private function processXML(success:Boolean) {
		if (success) {
			interval = obj_xml.firstChild.attributes.interval;
			for (var i:Number = 0; i < obj_xml.firstChild.childNodes.length; i++) 
			{
				var myobj:Object = new Object();
				for (var j:Number = 0; j < obj_xml.firstChild.childNodes[i].childNodes.length; j++) 
				{
					if (obj_xml.firstChild.childNodes[i].childNodes[j].nodeName == "author") {
						myobj.author = obj_xml.firstChild.childNodes[i].childNodes[j].firstChild.nodeValue;
					}
					if (obj_xml.firstChild.childNodes[i].childNodes[j].nodeName == "text") {
						myobj.text = obj_xml.firstChild.childNodes[i].childNodes[j].firstChild.nodeValue;
					}
				}
				quotearr.push(myobj);
			}
			Tweener.addTween(quotes_mc.controls_mc, { _x:-(quotes_mc.controls_mc._width + 5), time:0.6, transition:"easeInOutQuint" } );
			Tweener.addTween(quotes_mc.line_mc, { _x: -(Stage.width-250), time:0.6, transition:"easeInOutQuint" } );
			Tweener.addTween(quotes_mc.bg_mc, { _x: -(Stage.width - 250), time:0.6, transition:"easeInOutQuint" } );
			currquote = Math.floor(Math.random()*(quotearr.length - 1));
			loadNext();
			startShow();
		}
	}
	
	private function startShow() {
		isplaying = true;
		intervalid = setInterval(this, "loadNext", interval)
	}
	
	private function stopShow() {
		clearInterval(intervalid);
	}
	
	private function loadNext() {
		currquote++;
		if (currquote == quotearr.length)
			currquote = 0;
		changeQuote();
	}
	
	private function changeQuote() {
		Tweener.addTween(quotes_mc.author_txt, { _alpha:0, time:0.5, transition:"easeInQuad" });
		Tweener.addTween(quotes_mc.text_txt, { _alpha:0, time:0.5, transition:"easeInQuad", onComplete:Delegate.create(this, function() {
			quotes_mc.text_txt.text = quotearr[currquote].text;
			quotes_mc.text_txt._x = -(Stage.width - 250);
			quotes_mc.text_txt._width = (Stage.width - 250);
			quotes_mc.author_txt.text = quotearr[currquote].author;
			quotes_mc.author_txt._width = (Stage.width - 270);
			quotes_mc.author_txt._x = -(Stage.width - 270);
			quotes_mc.author_txt._y = quotes_mc.text_txt._height;
			Tweener.addTween(quotes_mc.line_mc, { _y:quotes_mc.text_txt._height, time:0.7, delay:0.2, transition:"easeInOutQuint" } );
			Tweener.addTween(quotes_mc.controls_mc, { _y:(quotes_mc.text_txt._height + 1 * quotes_mc.author_txt._height - quotes_mc.controls_mc._height - 5), time:0.7, delay:0.2, transition:"easeInOutQuint" } );
			Tweener.addTween(quotes_mc.bg_mc, { _height:(quotes_mc.text_txt._height + 1 * quotes_mc.author_txt._height), time:0.7, delay:0.2, transition:"easeInOutQuint", onComplete:Delegate.create(this, function() {
				Tweener.addTween(quotes_mc.text_txt, { _alpha:100, time:0.5, transition:"easeInQuad" } );
				Tweener.addTween(quotes_mc.author_txt, { _alpha:100, time:0.5, transition:"easeInQuad" } );
			}) } );
		}) } );
	}
	
	private function onResize() {
		quotes_mc._x = Stage.width;
		quotes_mc._y = 220;
		
		if (quotearr.length != 0) {
			Tweener.addTween(quotes_mc.bg_mc, { _width:(Stage.width - 250), time:0.7, transition:"easeInOutQuad" } );
			Tweener.addTween(quotes_mc.line_mc, { _width:(Stage.width - 250), time:0.7, transition:"easeInOutQuad" } );
			Tweener.addTween(quotes_mc.bg_mc, { _x:-(Stage.width - 250), time:0.7, transition:"easeInOutQuad" } );
			Tweener.addTween(quotes_mc.line_mc, { _x: -(Stage.width - 250), time:0.7, transition:"easeInOutQuad" } );
			Tweener.addTween(quotes_mc.text_txt, { _width:(Stage.width - 250), time:0.7, transition:"easeInOutQuad", onComplete:Delegate.create(this, function() {
				Tweener.addTween(quotes_mc.author_txt, { _y:quotes_mc.text_txt._height, time:0.7, transition:"easeInOutQuint" } );
				Tweener.addTween(quotes_mc.line_mc, { _y:quotes_mc.text_txt._height, time:0.7, transition:"easeInOutQuint" } );
				Tweener.addTween(quotes_mc.bg_mc, { _height:(quotes_mc.text_txt._height + 1 * quotes_mc.author_txt._height), time:0.7, transition:	"easeInOutQuint" } );
			}) } );
			Tweener.addTween(quotes_mc.author_txt, { _width:(Stage.width - 270), time:0.7, transition:"easeInOutQuad" } );
			Tweener.addTween(quotes_mc.text_txt, { _x: -(Stage.width - 250), time:0.7, transition:"easeInOutQuad" } );
			Tweener.addTween(quotes_mc.author_txt, { _x: -(Stage.width - 270), time:0.7, transition:"easeInOutQuad" } );
		}
	}
	
}