﻿import bgswitcher.BGSwitcher;
import template.TemplateDisplayObject;
import com.maheshj.UI.core.DisplayObject;
import com.maheshj.UI.RMenu;
import com.maheshj.UI.ScrollBox;
import com.maheshj.UI.VerticalScrollBox;
import com.maheshj.utils.IXML;
import com.maheshj.utils.ContentLoader;
import mx.utils.Delegate;
import SWFAddress;
import caurina.transitions.*;
import template.*;

class template.PhotographerTemplate extends TemplateDisplayObject {
	
	private var UIManager:StageManager;
	private var config_xml:XML;
	private var rMenu:RMenu;
	private var con_cl:ContentLoader;
	private var isInit:Boolean
	private var initlist:Object;
	private var currlinkobj:Object;
	private var prevlinkid:String;
	private var menuObj:Object;
	
	private var menu_mc:MainMenu;
	private var footer_mc:DisplayObject;
	private var logo_mc:MovieClip;
	private var cbg_mc:MovieClip;
	private var bg_mc:BGSwitcher;
	private var text_mc:TextContent;
	private var fs_mc:MovieClip;
	private var music_mc:MP3Player;
	private var page_mc:Page;
	private var fsn_mc:MovieClip;
	private var bgss:Boolean;
	private var sitetitle1:String;
	private var sitetitle2:String;
	private var ownername:String;
	private var ownerlink:String;
	
	private var gen_txt:TextField;
	private var gencount:Number;
	
	public static function main(target:MovieClip):Void
    {
        target.__proto__ = PhotographerTemplate.prototype;
        //target.init();
    }
    
	/**
	 * Method used to initialize all the variables, functionality, etc. Used to set up the listeners, configuration XML files paths to all the objects in the template, SWFAddress listeners, context menu of the template, fullscreen functionality, etc.
	 */
    public function init()
    {	
		gencount = 0;
		
		isInit = false;
		
		initlist = new Object();
		menuObj = new Object();
		
		initlist.ImageLoadInit = Delegate.create(this, function(e:Object) {
			menu_mc.init();
			bgss = bg_mc.slideShowOn;
			bg_mc.removeEventListener("ImageLoadInit", initlist);
			bg_mc.removeEventListener("BGVideoStarted", initlist);
		});
		
		initlist.BGVideoStarted = Delegate.create(this, function(e:Object) {
			menu_mc.init();
			bg_mc.removeEventListener("ImageLoadInit", initlist);
			bg_mc.removeEventListener("BGVideoStarted", initlist);
		});
		
		initlist.MainMenuInit = Delegate.create(this, function(e:Object) {
			Tweener.addTween(footer_mc, { _x:(Stage.width - footer_mc._width), time:0.3, transition:"easeInOutQuint" } );
			Tweener.addTween(fs_mc, { _alpha:100, time:0.35, transition:"easeInQuad", delay:0.35 } );
			Tweener.addTween(music_mc, { _alpha:100, time:0.35, transition:"easeInQuad"} );
			Tweener.addTween(logo_mc, { _x:(Stage.width - logo_mc._width), time:0.5, transition:"easeInOutQuint", onComplete:Delegate.create(this, function() {
				menu_mc.visible = true;
				menu_mc.enable();
				music_mc.playMusic();
				isInit = true;
				SWFAddress.setHistory(false);
				SWFAddress.addEventListener(SWFAddressEvent.CHANGE, Delegate.create(this, function() {
					gencount++;
					if (gencount > 1) {
						var myval:String = SWFAddress.getValue();
						//var mystr:String = myval.substring(1, );
						var mystr:String = SWFAddress.getValue().split("/")[1];
						if (basePath != "/" + mystr + "/") {
							basePath =  "/" + mystr + "/";
							menuObj.itemObj = menu_mc.getLinkByID(mystr);
							loadMenuItem(menuObj);
						}
					}
				}));
				menu_mc.addEventListener("MenuItemClicked", Delegate.create(this, function(e:Object) {
					SWFAddress.setValue("/" + e.itemObj.ID + "/");
				}));
				StageResized();
				menu_mc.removeEventListener("MainMenuInit", initlist);
				if (SWFAddress.getValue() != "null" and SWFAddress.getValue() != "/") {
					SWFAddress.setValue(SWFAddress.getValue());
				}else {
					menu_mc.getDefaultItem();
				}
				SWFAddress.setHistory(true);
				delete initlist;
			}) } );
		});
		
		cbg_mc.useHandCursor = false;
		
		cbg_mc.onRollOver = function() { };
		
		bg_mc.addEventListener("ImageLoadInit", initlist);
		
		bg_mc.addEventListener("BGVideoStarted", initlist);
		
		bg_mc.addEventListener("SlideShowToggled", Delegate.create(this, function(e:Object) {
			if (e.ison == "true") {
				bgss = true;
			}else {
				bgss = false;
			}
		}));
		
		menu_mc.addEventListener("MainMenuInit", initlist);
		
		page_mc.addEventListener("DisplayObjectExit", this);
		
		config_xml = IXML.createXML("xml/siteconfig.xml", "file");
		
		config_xml.onLoad = Delegate.create(this, initManagers);
		
		fs_mc.ul_mc._visible = false;
		
		fs_mc.onRollOver = Delegate.create(this, function() {
			fs_mc.ul_mc._visible = true;
			Tweener.addTween(fs_mc.ul_mc, { _width:fs_mc.label_txt._width-3.5, time:0.6, transition:"easeOutQuint" } );
		});
		
		fs_mc.onRollOut = fs_mc.onReleaseOutside = Delegate.create(this, function() {
			Tweener.addTween(fs_mc.ul_mc, { _width:1, time:0.3, transition:"easeInOutQuint", onComplete:Delegate.create(this, function() {
				fs_mc.ul_mc._visible = false;
			}) } );
		});
		
		fs_mc.onRelease = Delegate.create(this, function() {
			if (Stage["displayState"] == "fullScreen") {
				Tweener.removeTweens(fsn_mc);
				fsn_mc._alpha = 0;
				Stage["displayState"] = "normal";
			}else {
				fsn_mc._alpha = 100;
				Tweener.addTween(fsn_mc, { _alpha:0, time:1, transition:"linear", delay:3 } );
				Stage["displayState"] = "fullscreen";
			}
		});
		
		logo_mc.onRelease = Delegate.create(this, function() {
			if (menu_mc.hasDefault) {
				menu_mc.getDefaultItem();
			}else {
				SWFAddress.setValue("/");
			}
		});
		
		con_cl = new ContentLoader();
		
		GlobalVars.mp3Player = music_mc;
		
		fscommand("fullscreen", true);
		
    }
	
	private function initManagers(success) {
		if (success) {
			
			UIManager = new StageManager(this);
			
			UIManager.addEventListener("StageResized", footer_mc);
			
			menu_mc.registerListener(this);
			
			for (var i:Number = 0; i < config_xml.firstChild.childNodes.length; i++) {
				for (var j:Number = 0; j < config_xml.firstChild.childNodes[i].childNodes.length; j++) 
				{
					if (config_xml.firstChild.childNodes[i].attributes.mc != undefined) {
						this[config_xml.firstChild.childNodes[i].attributes.mc][config_xml.firstChild.childNodes[i].childNodes[j].nodeName] = config_xml.firstChild.childNodes[i].childNodes[j].firstChild.nodeValue;
					}
					if (config_xml.firstChild.childNodes[i].attributes.variable != undefined) {
						this[config_xml.firstChild.childNodes[i].attributes.variable] = config_xml.firstChild.childNodes[i].childNodes[j].firstChild.nodeValue;
					}
				}
			}
			
			var company_cmi:ContextMenuItem = new ContextMenuItem(ownername, Delegate.create(this, function() {
				getURL(ownerlink, "_blank");
			}));
			
			var fullscreen_cmi:ContextMenuItem = new ContextMenuItem("Toggle Fullscreen", Delegate.create(this, function() {
				if (Stage["displayState"] == "fullScreen") {
					Tweener.removeTweens(fsn_mc);
					fsn_mc._alpha = 0;
					Stage["displayState"] = "normal";
				}else {
					fsn_mc._alpha = 100;
					Tweener.addTween(fsn_mc, { _alpha:0, time:1, transition:"linear", delay:3 } );
					Stage["displayState"] = "fullScreen";
				}
			}));
			
			rMenu = new RMenu(true);
			rMenu.add(company_cmi);
			rMenu.add(fullscreen_cmi);
			
			this.menu = rMenu;
			
			GlobalVars.contextMenu = rMenu;
		
		}else {
			trace("Error loading XML...");
		}
		
		UIManager.onResize();
	}
	
	/**
	 * Stage listener.
	 */
	private function StageResized() {
		
		if (isInit == true) {
			menu_mc._x = 0;
			menu_mc._y = Math.round(Stage.height - 25);
		
			footer_mc._x = Stage.width - footer_mc.getDimensions().width;
			footer_mc._y = Stage.height - footer_mc.getDimensions().height;
			
			logo_mc._x = Stage.width - logo_mc._width;
			
			music_mc._x = Stage.width - music_mc._width - 5;
			music_mc._y = menu_mc._y + 3;
			
			fs_mc._x = Stage.width - fs_mc._width - music_mc._width - menu_mc.itemGap - 5;
			fs_mc._y = menu_mc._y+3;
			
			fsn_mc._x = Stage.width / 2 + 1*40;
			fsn_mc._y = Stage.height / 2 - 10;
			
			cbg_mc._x = 0.2 * Stage.width;
			cbg_mc._height = 0.9*Stage.height;
			text_mc._x = cbg_mc._x+5;
			
			switch (currlinkobj.type) {
				case "text":
				page_mc._x = 0;
				cbg_mc._y = 0;
				text_mc._x = cbg_mc._x+5;
				text_mc.resize(380, cbg_mc._height-10);
				break;
				
				case "contentfile":
				page_mc._x = cbg_mc._x;
				cbg_mc._y = 0;
				break;
				
				default:
				page_mc._x = 0;
				cbg_mc._y = -Stage.height;
				text_mc._y = 5;
				break;
			}
		}else {
			footer_mc._x = Stage.width;
			footer_mc._y = Stage.height - footer_mc._height;
			
			logo_mc._x = Stage.width + 5;
			logo_mc._y = 50;
			
			music_mc._x = Stage.width - music_mc._width - 5;
			music_mc._y = Math.round(Stage.height - 22);
			
			fs_mc._x = Stage.width - fs_mc._width - music_mc._width - 11;
			fs_mc._y = Math.round(Stage.height - 22);
			
			cbg_mc._y = -Stage.height;
			
			text_mc._y = 5;
			text_mc._visible = false;
		}
	}
	
	private function loadMenuItem(e:Object) {
		currlinkobj = e.itemObj;
		page_mc.exit();
	}
	
	/**
	 * This method implements the core functionality of loading and managing the content in reponse to either SWFAddress URL change or menu item clicks.
	 * @param	e - Event object containing all the info of the item to be loaded
	 */
	private function DisplayObjectExit(e:Object) {
		if (currlinkobj.slideshow == "true") {
			if (bgss) {
				if (!bg_mc.slideShowOn) {
					bg_mc.slideShowOn = true;
				}
			}
		}else {
			if (bg_mc.slideShowOn) {
				bg_mc.slideShowOn = false;
			}
		}
		if (prevlinkid != currlinkobj.ID or currlinkobj.ID == undefined) {
			SWFAddress.setTitle(sitetitle1 + currlinkobj.title + sitetitle2);
			switch(currlinkobj.type) {
				case "text":
				Tweener.addTween(cbg_mc, { _y:0, time:0.7, transition:"easeInOutQuint", onComplete:Delegate.create(this, function() {
					text_mc._visible = true;
					text_mc.setText(currlinkobj.title, currlinkobj.xmlfile);
					Tweener.addTween(text_mc, { _alpha:100, time:0.5, transition:"easeInOutQuint", onComplete:Delegate.create(this, function() {
						StageResized();
					}) } );
				}) } );
				break;
			
				case "contentfile":
				page_mc._x = cbg_mc._x;
				Tweener.addTween(cbg_mc, { _y:0, time:0.7, transition:"easeInOutQuint", onComplete:Delegate.create(this, function() {
					Tweener.addTween(text_mc, { _alpha: 0, time:0.5, transition:"easeInOutQuint", onComplete:Delegate.create(this, function() {
						text_mc._visible = false;
						page_mc.xmlFile = currlinkobj.xmlfile;
						if (currlinkobj.iscustom == "true") {
							page_mc.isCustom = true;
						}else {
							page_mc.isCustom = false;
						}
						page_mc.loadFile(currlinkobj.file);
						StageResized();
					}) } );
				}) } );
				break;
				
				case "file":
				page_mc._x = 0;
				page_mc.basePath = SWFAddress.getValue().split("/").slice(0, 2).join("/") + "/";
				Tweener.addTween(text_mc, { _alpha:0, time:0.5, transition:"easeInOutQuint", onComplete:Delegate.create(this, function() {
					text_mc._visible = false;
					Tweener.addTween(cbg_mc, { _y:-Stage.height, time:0.7, transition:"easeInOutQuint", onComplete:Delegate.create(this, function() {
						text_mc.content_mc.reset();
						page_mc.xmlFile = currlinkobj.xmlfile;
						if (currlinkobj.iscustom == "true") {
							page_mc.isCustom = true;
						}else {
							page_mc.isCustom = false;
						}
						page_mc.loadFile(currlinkobj.file);
						StageResized();
					}) } );
				}) } );
				break;
			
				default:
				if (menu_mc.hasDefault) {
					menu_mc.getDefaultItem();
				}else {
					SWFAddress.setTitle(sitetitle1 + sitetitle2);
					Tweener.addTween(text_mc, { _alpha: 0, time:0.5, transition:"easeInOutQuint", onComplete:Delegate.create(this, function() {
						text_mc._visible = false;
						Tweener.addTween(cbg_mc, { _y:-Stage.height, time:0.7, transition:"easeInOutQuint", onComplete:Delegate.create(this, function() {
							currlinkobj.type = "/";
							StageResized();
						}) } );
					}) } );
				}
				break;
			}
			prevlinkid = currlinkobj.ID;
		}else {
			//if (gencount >= 4) {
			if (menu_mc.hasDefault) {
				menu_mc.getDefaultItem();
			}else{
				SWFAddress.setTitle(sitetitle1 + sitetitle2);
				SWFAddress.setValue("/");
			}
			//}
		}
	}
}