﻿import mx.utils.Delegate;
import com.maheshj.UI.VerticalScrollBox;
import caurina.transitions.*;

/**
 * This class is the dialog box in which the content is displayed.
 */
class template.TextContent extends MovieClip
{
	private var sb_mc:VerticalScrollBox;
	private var bg_mc:MovieClip;
	private var title_txt:TextField;
	private var ul_mc:MovieClip;
	
	private var isvis:Boolean;
	
	public function TextContent() 
	{
		init();
	}
	
	/**
	 * Use this function to initialize the info dialog
	 */
	public function init() {
		setVisibility(false);
		
		title_txt.autoSize = true;
		title_txt.html = true;
	}
	
	/**
	 * Use this function to set the title and description to be displayed
	 * @param	title - the title text
	 * @param	str - the description text
	 */
	public function setText(title:String, str:String) {
		sb_mc.content_mc.reset();
		Tweener.addTween(title_txt, { _alpha:0, time:0.2, transition:"easeInQuad", onComplete:Delegate.create(this, function() {
			title_txt.htmlText = "<font letterspacing='1'>" + title + "</font>";
			Tweener.addTween(title_txt, { _alpha:100, time:0.2, transition:"easeInQuad" } );
		}) } );
		sb_mc.scrollTo(0);
		Tweener.addTween(sb_mc, { _alpha:0, time:0.2, transition:"easeInQuad", onComplete:Delegate.create(this, function() {
			sb_mc.content_mc.loadText(str);
			Tweener.addTween(sb_mc, { _alpha:100, time:0.2, transition:"easeInQuad" } );
		}) } );
	}
	
	private function ScrollPaneResized(e:Object) {
		sb_mc.resize(e.width, e.height);
	}
	
	/**
	 * Call this function to resize the text content scroller
	 * @param	width
	 * @param	height
	 */
	public function resize(width, height) {
		title_txt._width = width - 10;
		ul_mc._width = width;
		sb_mc.resize(width, height - 37);
		bg_mc._width = width;
		bg_mc._height = height;
	}
	
	/**
	 * Use this function to get the dimensions of the dialog.
	 * @return - an object with properties 'width' and 'height' of type Number.
	 */
	public function getDimensions():Object {
		var myobj:Object = new Object();
		myobj.width = bg_mc._width;
		myobj.height = bg_mc._height;
		return myobj;
	}
	
	/**
	 * Use this function to set the visibility of the dialog
	 * @param	bool - a boolean value
	 */
	public  function setVisibility(bool:Boolean) {
		if (bool == true) {
			_visible = true;
			isvis = true;
			Tweener.addTween(this, { _alpha:100, time:0.3, transition:"easeInQuad" } );
		}else {
			isvis = false;
			Tweener.addTween(this, { _alpha:0, time:0.3, transition:"easeInQuad", onComplete:Delegate.create(this, function() {
				_visible = false;
			}) } );
		}
	}
	
	/**
	 * Use this function to toggle the visibility of the dialog
	 */
	public function toggleVisiblity() {
		if (isvis == true) {
			setVisibility(false);
		}else {
			setVisibility(true);
		}
	}
	
}