﻿import com.maheshj.UI.core.DisplayObject;
import com.maheshj.utils.IXML;
import mx.utils.Delegate;
import caurina.transitions.*;

/**
 * This class can be used to load an text content from XML files.
 */
dynamic class template.TextContentLoader extends DisplayObject
{
	private var text_xml:XML;
	private var content_txt:TextField;
	private var style:TextField.StyleSheet;
	
	/**
	 * Use this method to register a movieclip as this class
	 * @param	target - the movieclip to be registered
	 */
	public static function main(target:MovieClip):Void
    	{
        target.__proto__ = TextContentLoader.prototype;
        target.init();
   	}
	
	/**
	 * The constructor.
	 */
	public function TextContentLoader() 
	{
		init();
	}
	
	/**
	 * Method used to initialize all the variables, functionality, etc.
	 */
	public function init() {
		text_xml = IXML.createXML();
		text_xml.onLoad = Delegate.create(this, processXML);
		
		content_txt.autoSize = true;
		content_txt.html = true;
		content_txt.condenseWhite = true;
		content_txt.htmlText = "<i>Loading...</i>";
		
		style = new TextField.StyleSheet();
		style.load("textstyle.css");
		content_txt.styleSheet = style;
	}
	
	/**
	 * Use this method to load the XML file containing the text to be displayed
	 * @param	str - path of the XML file.
	 */
	public function loadText(str:String) {
		if (str != undefined) {
			text_xml.load(str);
		}
	}
	
	/**
	 * Call this function to reset the text box.
	 */
	public function reset() {
		content_txt.htmlText = "<i>Loading...</i>";
		_parent.scrollTo(0);
		_parent.resize();
	}
	
	private function resize(w:Number, h:Number) {
		content_txt._width = w - 10;
	}
	
	private function processXML() {
		var str:String = text_xml.firstChild.childNodes[0].nodeValue;
		Tweener.addTween(content_txt, {_alpha:0, time:0.3, transition:"easeOutQuad", onComplete:Delegate.create(this, function() {
			content_txt.htmlText = str;
			_parent.resize();
			Tweener.addTween(content_txt, { _alpha:100, time:0.3, transition:"easeInQuad" } );
	}) } );
	}
	
	private function ScrollPaneResized(e:Object) {
		resize(e.width, e.height);
	}
	
}