<div id="htmlroot">
	<?php
		//This function id used to generate the html code required for <type>Text</type> elements in sitemainmenu.xml
		function generateText($fname, $id)
		{
			//Creating objects of DomDocument & XsltProcessor and loading the desired documents into them

			$xp = new XsltProcessor();
			$xsl = new DomDocument('1.0');
			$xsl->load('xsl/text.xsl');
			$xp->importStylesheet($xsl);
			$xml_doc = new DomDocument;
			$xml_doc->load($fname);
		
			$final = "		<div id=\"content\">\n" . $xp->transformToXML($xml_doc) ."\n		</div>";
		
			return $final;
		}
			
		//This function is used to generate html code required for gallery of images
		//e.g. of $fname value ... xml/people.xml or xml/nature.xml
		function generateGallery($fname)
		{
			//Variables to process core.xsl and $fname xml files
			$xp = new XsltProcessor();
			$xsl = new DomDocument;
			$xsl->load('xsl/core.xsl');
			$xp->importStylesheet($xsl);
		
			$xml_doc = new DomDocument;
			$xml_doc->load($fname);
		
			//Generate the title and filename list for galleries desired
			$galList = $xp->transformToXML($xml_doc);
		
			//Variables to process images.xsl and gallery xml files (from list in $html)
			$xpIn = new XsltProcessor();
			$xslIn = new DomDocument;
			$xml_docIn = new DomDocument;
			$xslIn->load('xsl/images.xsl');
			$xpIn->importStylesheet($xslIn);
		
			//Converts string list in a array form(** is the seperator used originally)
			$arr = explode("**",$galList);
			$start = "            <div id=\"gallerycat\">";
			$mid = "</div>\n            <div id=\"gallery\">\n            	<div \"images\">";
			$end = "\n                </div>\n            </div>\n";
		
			$count = count($arr);
			$i=0;
			$final="";
		
			while($i<$count-1)
			{
				$brk = explode(",",$arr[$i++]);
			//Load XML document taking content from List generated above
				$xml_docIn->load($brk[1]);
				$gallery = $xpIn->transformToXML($xml_docIn);
				$temp = $start . $brk[0]. $mid. $gallery . $end; 
				$final = $final . $temp;
			}
			return $final;
		}

		//This function created the contents of <div id="header"></div> tag
		//Takes input from sitemainmenu.xml file
		function writeHeader($txt)
		{
			$arr = explode("**",$txt);
		
			$header ="		<div id=\"header\">\n			<div id=\"menu\">\n";
		
			$hItemStart ="             		<div id=\"menuitem\"><a href=\"";
			$hItemMid = "\">";
			$hItemEnd = "</a></div>\n";
		
			$count = count($arr);
			$i=0;
		
			while($i<$count-1)
			{
				$content = explode(",",$arr[$i++]);
				if($content[2]=="l")
					$temp = $content[3];
				else 
					$temp = "#".$content[1];
		
				$header = $header . $hItemStart. $temp . $hItemMid .$content[0]. $hItemEnd;
			}
			$header = $header . "            		</div>\n		</div>\n";
			return $header;
		}

		//variable will store contents of body
		$body = "";

		//Variables for processing sitemainmenu.xml and sitemainmenu.xsl files
		$Mainxp = new XsltProcessor();
		$Mainxsl = new DomDocument('1.0');
		$Mainxsl->load('xsl/sitemainmenu.xsl');
		$Mainxp->importStylesheet($Mainxsl);
		
		$Mainxml_doc = new DomDocument('1.0');
		$Mainxml_doc->load('xml/sitemainmenu.xml');
		$txtSiteMainMenu = $Mainxp->transformToXML($Mainxml_doc);

		//Store header contents in a variable
		$header = writeHeader($txtSiteMainMenu);
		
		$arr = explode("**",$txtSiteMainMenu);
		$count = count($arr);
		$i=0;

		//Depending upon the type symbol create gallery or text (call generateGallery() or generateText() respectively
		while($i<$count-1)
		{
			$content = explode(",",$arr[$i++]);
			
			if($content[2]=="f")
			{
				$temp = generateGallery($content[3]);
			}
			
			else if($content[2]=="t")
			{
				$temp = generateText($content[3], $content[1]);
			}
			
			else 
				continue;
		
			$body = $body . "        <a name=\"". $content[1] . "\">\n". $header . $temp . "\n        </a>\n";
		}

		//put the $body in <div id="root">
		echo $body;
	?>
</div>